/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.List;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.HistoryLevelSetupCommand;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;

public class DetermineHistoryLevelCmd
implements Command<HistoryLevel> {
    private final List<HistoryLevel> historyLevels;

    public DetermineHistoryLevelCmd(List<HistoryLevel> historyLevels) {
        this.historyLevels = historyLevels;
    }

    @Override
    public HistoryLevel execute(CommandContext commandContext) {
        Integer databaseHistoryLevel = HistoryLevelSetupCommand.databaseHistoryLevel(commandContext);
        HistoryLevel result = null;
        if (databaseHistoryLevel != null) {
            for (HistoryLevel historyLevel : this.historyLevels) {
                if (historyLevel.getId() != databaseHistoryLevel.intValue()) continue;
                result = historyLevel;
                break;
            }
            if (result != null) {
                return result;
            }
            throw new ProcessEngineException("The configured history level with id='%s' is not registered in this config.".formatted(databaseHistoryLevel));
        }
        return null;
    }
}

