/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.application.ProcessApplicationRegistration;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.RepositoryService;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cfg.TransactionLogger;
import org.operaton.bpm.engine.impl.cfg.TransactionState;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.operaton.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.operaton.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessApplicationDeploymentImpl;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceManager;
import org.operaton.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.operaton.bpm.engine.impl.repository.CandidateDeploymentImpl;
import org.operaton.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.operaton.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.impl.util.StringUtil;
import org.operaton.bpm.engine.repository.CandidateDeployment;
import org.operaton.bpm.engine.repository.Deployment;
import org.operaton.bpm.engine.repository.DeploymentHandler;
import org.operaton.bpm.engine.repository.DeploymentWithDefinitions;
import org.operaton.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import org.operaton.bpm.engine.repository.ProcessDefinition;
import org.operaton.bpm.engine.repository.Resource;
import org.operaton.bpm.model.bpmn.Bpmn;
import org.operaton.bpm.model.bpmn.BpmnModelInstance;
import org.operaton.bpm.model.bpmn.instance.Process;
import org.operaton.bpm.model.cmmn.Cmmn;
import org.operaton.bpm.model.cmmn.instance.Case;

public class DeployCmd
implements Command<DeploymentWithDefinitions>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    private static final TransactionLogger TX_LOG = ProcessEngineLogger.TX_LOGGER;
    protected DeploymentBuilderImpl deploymentBuilder;
    protected DeploymentHandler deploymentHandler;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentWithDefinitions execute(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isDeploymentSynchronized()) {
            Class<ProcessEngine> clazz = ProcessEngine.class;
            synchronized (ProcessEngine.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.doExecute(commandContext);
            }
        }
        return this.doExecute(commandContext);
    }

    protected DeploymentWithDefinitions doExecute(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getDeploymentManager();
        ProcessEngineImpl processEngine = commandContext.getProcessEngineConfiguration().getProcessEngine();
        this.deploymentHandler = commandContext.getProcessEngineConfiguration().getDeploymentHandlerFactory().buildDeploymentHandler(processEngine);
        Set<String> deploymentIds = this.getAllDeploymentIds(this.deploymentBuilder);
        if (!deploymentIds.isEmpty()) {
            String[] deploymentIdArray = deploymentIds.toArray(new String[deploymentIds.size()]);
            List<DeploymentEntity> deployments = deploymentManager.findDeploymentsByIds(deploymentIdArray);
            this.ensureDeploymentsWithIdsExists(deploymentIds, deployments);
        }
        this.checkCreateAndReadDeployments(commandContext, deploymentIds);
        String nameFromDeployment = this.deploymentBuilder.getNameFromDeployment();
        this.setDeploymentName(nameFromDeployment, this.deploymentBuilder, commandContext);
        List<ResourceEntity> resources = this.getResources(this.deploymentBuilder, commandContext);
        this.addResources(resources, this.deploymentBuilder);
        Collection<String> resourceNames = this.deploymentBuilder.getResourceNames();
        if (resourceNames == null || resourceNames.isEmpty()) {
            throw new NotValidException("No deployment resources contained to deploy.");
        }
        DeploymentWithDefinitions deployment = commandContext.runWithoutAuthorization(() -> {
            this.acquireExclusiveLock(commandContext);
            DeploymentEntity deploymentToRegister = this.initDeployment();
            Map<String, ResourceEntity> resourcesToDeploy = this.resolveResourcesToDeploy(commandContext, deploymentToRegister);
            HashMap<String, ResourceEntity> resourcesToIgnore = new HashMap<String, ResourceEntity>(deploymentToRegister.getResources());
            resourcesToIgnore.keySet().removeAll(resourcesToDeploy.keySet());
            CandidateDeploymentImpl candidateDeployment = CandidateDeploymentImpl.fromDeploymentEntity(deploymentToRegister);
            if (!resourcesToDeploy.isEmpty()) {
                LOG.debugCreatingNewDeployment();
                deploymentToRegister.setResources(resourcesToDeploy);
                this.deploy(commandContext, deploymentToRegister);
            } else {
                String duplicateDeploymentId = this.deploymentHandler.determineDuplicateDeployment(candidateDeployment);
                deploymentToRegister = commandContext.getDeploymentManager().findDeploymentById(duplicateDeploymentId);
            }
            this.scheduleProcessDefinitionActivation(commandContext, deploymentToRegister);
            if (this.deploymentBuilder instanceof ProcessApplicationDeploymentBuilder) {
                ProcessApplicationRegistration registration = this.registerProcessApplication(commandContext, deploymentToRegister, candidateDeployment, resourcesToIgnore.values());
                return new ProcessApplicationDeploymentImpl(deploymentToRegister, registration);
            }
            this.registerWithJobExecutor(commandContext, deploymentToRegister);
            return deploymentToRegister;
        });
        this.createUserOperationLog(this.deploymentBuilder, deployment, commandContext);
        return deployment;
    }

    protected void acquireExclusiveLock(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isDeploymentLockUsed()) {
            commandContext.getPropertyManager().acquireExclusiveLock();
        } else {
            LOG.warnDisabledDeploymentLock();
        }
    }

    protected Map<String, ResourceEntity> resolveResourcesToDeploy(CommandContext commandContext, DeploymentEntity candidateDeployment) {
        Map<Object, Object> resourcesToDeploy = new HashMap();
        Map<String, ResourceEntity> candidateResources = candidateDeployment.getResources();
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            String source;
            if (candidateDeployment.getName() == null) {
                LOG.warnFilteringDuplicatesEnabledWithNullDeploymentName();
            }
            if ((source = candidateDeployment.getSource()) == null || source.isEmpty()) {
                source = "process application";
            }
            Map<String, ResourceEntity> existingResources = commandContext.getResourceManager().findLatestResourcesByDeploymentName(candidateDeployment.getName(), candidateResources.keySet(), source, candidateDeployment.getTenantId());
            for (ResourceEntity deployedResource : candidateResources.values()) {
                String resourceName = deployedResource.getName();
                ResourceEntity existingResource = existingResources.get(resourceName);
                if (existingResource != null && !existingResource.isGenerated() && !this.deploymentHandler.shouldDeployResource(deployedResource, existingResource)) continue;
                if (this.deploymentBuilder.isDeployChangedOnly()) {
                    resourcesToDeploy.put(resourceName, deployedResource);
                    continue;
                }
                resourcesToDeploy = candidateResources;
                break;
            }
        } else {
            resourcesToDeploy = candidateResources;
        }
        return resourcesToDeploy;
    }

    protected void deploy(CommandContext commandContext, DeploymentEntity deployment) {
        deployment.setNew(true);
        commandContext.getDeploymentManager().insertDeployment(deployment);
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentWithDefinitions deployment) {
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            RepositoryService repositoryService = commandContext.getProcessEngineConfiguration().getRepositoryService();
            for (ProcessDefinition processDefinition : this.getDeployedProcesses(commandContext, deployment)) {
                repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
                repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).executionDate(this.deploymentBuilder.getProcessDefinitionsActivationDate()).activate();
            }
        }
    }

    protected ProcessApplicationRegistration registerProcessApplication(CommandContext commandContext, DeploymentEntity deploymentToRegister, CandidateDeployment candidateDeployment, Collection ignoredResources) {
        ProcessApplicationDeploymentBuilderImpl appDeploymentBuilder = (ProcessApplicationDeploymentBuilderImpl)this.deploymentBuilder;
        ProcessApplicationReference appReference = appDeploymentBuilder.getProcessApplicationReference();
        HashSet<String> deploymentsToRegister = new HashSet<String>(Collections.singleton(deploymentToRegister.getId()));
        if (appDeploymentBuilder.isResumePreviousVersions()) {
            String resumePreviousBy;
            switch (resumePreviousBy = appDeploymentBuilder.getResumePreviousVersionsBy()) {
                case "deployment-name": {
                    deploymentsToRegister.addAll(this.deploymentHandler.determineDeploymentsToResumeByDeploymentName(candidateDeployment));
                    break;
                }
                default: {
                    String[] processDefinitionKeys = this.getProcessDefinitionsFromResources(commandContext, deploymentToRegister, ignoredResources);
                    if (processDefinitionKeys.length <= 0) break;
                    deploymentsToRegister.addAll(this.deploymentHandler.determineDeploymentsToResumeByProcessDefinitionKey(processDefinitionKeys));
                }
            }
        }
        return new RegisterProcessApplicationCmd(deploymentsToRegister, appReference).execute(commandContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithJobExecutor(CommandContext commandContext, Deployment deployment) {
        try {
            new RegisterDeploymentCmd(deployment.getId()).execute(commandContext);
        }
        finally {
            DeploymentFailListener listener = new DeploymentFailListener(deployment.getId(), commandContext.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew());
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                TX_LOG.debugTransactionOperation("Could not register transaction synchronization. Probably the TX has already been rolled back by application code.");
                listener.execute(commandContext);
            }
        }
    }

    protected void createUserOperationLog(DeploymentBuilderImpl deploymentBuilder, Deployment deployment, CommandContext commandContext) {
        UserOperationLogManager logManager = commandContext.getOperationLogManager();
        ArrayList<PropertyChange> properties = new ArrayList<PropertyChange>();
        PropertyChange filterDuplicate = new PropertyChange("duplicateFilterEnabled", null, deploymentBuilder.isDuplicateFilterEnabled());
        properties.add(filterDuplicate);
        if (deploymentBuilder.isDuplicateFilterEnabled()) {
            PropertyChange deployChangedOnly = new PropertyChange("deployChangedOnly", null, deploymentBuilder.isDeployChangedOnly());
            properties.add(deployChangedOnly);
        }
        logManager.logDeploymentOperation("Create", deployment.getId(), deployment.getTenantId(), properties);
    }

    protected DeploymentEntity initDeployment() {
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(ClockUtil.getCurrentTime());
        return deployment;
    }

    protected void setDeploymentName(String deploymentId, DeploymentBuilderImpl deploymentBuilder, CommandContext commandContext) {
        if (deploymentId != null && !deploymentId.isEmpty()) {
            DeploymentManager deploymentManager = commandContext.getDeploymentManager();
            DeploymentEntity deployment = deploymentManager.findDeploymentById(deploymentId);
            deploymentBuilder.getDeployment().setName(deployment.getName());
        }
    }

    protected void addResources(List<ResourceEntity> resources, DeploymentBuilderImpl deploymentBuilder) {
        DeploymentEntity deployment = deploymentBuilder.getDeployment();
        Map<String, ResourceEntity> existingResources = deployment.getResources();
        for (ResourceEntity resource : resources) {
            String resourceName = resource.getName();
            if (existingResources != null && existingResources.containsKey(resourceName)) {
                String message = "Cannot add resource with id '%s' and name '%s' from deployment with id '%s' to new deployment because the new deployment contains already a resource with same name.".formatted(resource.getId(), resourceName, resource.getDeploymentId());
                throw new NotValidException(message);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
            deploymentBuilder.addInputStream(resourceName, inputStream);
        }
    }

    protected List<String> getMissingElements(Set<String> expected, Map<String, ?> actual) {
        ArrayList<String> missingElements = new ArrayList<String>();
        for (String value : expected) {
            if (actual.containsKey(value)) continue;
            missingElements.add(value);
        }
        return missingElements;
    }

    protected List<ResourceEntity> getResources(DeploymentBuilderImpl deploymentBuilder, CommandContext commandContext) {
        ArrayList<ResourceEntity> resources = new ArrayList<ResourceEntity>();
        Set<String> deploymentIds = deploymentBuilder.getDeployments();
        resources.addAll(this.getResourcesByDeploymentId(deploymentIds, commandContext));
        Map<String, Set<String>> deploymentResourcesById = deploymentBuilder.getDeploymentResourcesById();
        resources.addAll(this.getResourcesById(deploymentResourcesById, commandContext));
        Map<String, Set<String>> deploymentResourcesByName = deploymentBuilder.getDeploymentResourcesByName();
        resources.addAll(this.getResourcesByName(deploymentResourcesByName, commandContext));
        this.checkDuplicateResourceName(resources);
        return resources;
    }

    protected List<ResourceEntity> getResourcesByDeploymentId(Set<String> deploymentIds, CommandContext commandContext) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        if (!deploymentIds.isEmpty()) {
            DeploymentManager deploymentManager = commandContext.getDeploymentManager();
            for (String deploymentId : deploymentIds) {
                DeploymentEntity deployment = deploymentManager.findDeploymentById(deploymentId);
                Map<String, ResourceEntity> resources = deployment.getResources();
                Collection<ResourceEntity> values = resources.values();
                result.addAll(values);
            }
        }
        return result;
    }

    protected List<ResourceEntity> getResourcesById(Map<String, Set<String>> resourcesById, CommandContext commandContext) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        ResourceManager resourceManager = commandContext.getResourceManager();
        for (Map.Entry<String, Set<String>> resourceEntry : resourcesById.entrySet()) {
            String deploymentId = resourceEntry.getKey();
            Set<String> resourceIds = resourceEntry.getValue();
            String[] resourceIdArray = resourceIds.toArray(new String[resourceIds.size()]);
            List<ResourceEntity> resources = resourceManager.findResourceByDeploymentIdAndResourceIds(deploymentId, resourceIdArray);
            this.ensureResourcesWithIdsExist(deploymentId, resourceIds, resources);
            result.addAll(resources);
        }
        return result;
    }

    protected List<ResourceEntity> getResourcesByName(Map<String, Set<String>> resourcesByName, CommandContext commandContext) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        ResourceManager resourceManager = commandContext.getResourceManager();
        for (Map.Entry<String, Set<String>> entry : resourcesByName.entrySet()) {
            String deploymentId = entry.getKey();
            Set<String> resourceNames = entry.getValue();
            String[] resourceNameArray = resourceNames.toArray(new String[resourceNames.size()]);
            List<ResourceEntity> resources = resourceManager.findResourceByDeploymentIdAndResourceNames(deploymentId, resourceNameArray);
            this.ensureResourcesWithNamesExist(deploymentId, resourceNames, resources);
            result.addAll(resources);
        }
        return result;
    }

    protected List<? extends ProcessDefinition> getDeployedProcesses(CommandContext commandContext, DeploymentWithDefinitions deployment) {
        List<ProcessDefinition> deployedProcessDefinitions = deployment.getDeployedProcessDefinitions();
        if (deployedProcessDefinitions == null) {
            ProcessDefinitionManager manager = commandContext.getProcessDefinitionManager();
            deployedProcessDefinitions = manager.findProcessDefinitionsByDeploymentId(deployment.getId());
        }
        return deployedProcessDefinitions;
    }

    protected String[] getProcessDefinitionsFromResources(CommandContext commandContext, DeploymentEntity deploymentToRegister, Collection ignoredResources) {
        HashSet<String> processDefinitionKeys = new HashSet<String>();
        processDefinitionKeys.addAll(this.parseProcessDefinitionKeys(ignoredResources));
        for (ProcessDefinition processDefinition : this.getDeployedProcesses(commandContext, deploymentToRegister)) {
            if (processDefinition.getVersion() <= 1) continue;
            processDefinitionKeys.add(processDefinition.getKey());
        }
        return processDefinitionKeys.toArray(new String[processDefinitionKeys.size()]);
    }

    protected Set<String> parseProcessDefinitionKeys(Collection<Resource> resources) {
        HashSet<String> processDefinitionKeys = new HashSet<String>(resources.size());
        for (Resource resource : resources) {
            BpmnModelInstance model;
            ByteArrayInputStream byteStream;
            if (this.isBpmnResource(resource)) {
                byteStream = new ByteArrayInputStream(resource.getBytes());
                model = Bpmn.readModelFromStream((InputStream)byteStream);
                for (Process process : model.getDefinitions().getChildElementsByType(Process.class)) {
                    processDefinitionKeys.add(process.getId());
                }
                continue;
            }
            if (!this.isCmmnResource(resource)) continue;
            byteStream = new ByteArrayInputStream(resource.getBytes());
            model = Cmmn.readModelFromStream((InputStream)byteStream);
            for (Case cmmnCase : model.getDefinitions().getCases()) {
                processDefinitionKeys.add(cmmnCase.getId());
            }
        }
        return processDefinitionKeys;
    }

    protected Set<String> getAllDeploymentIds(DeploymentBuilderImpl deploymentBuilder) {
        HashSet<String> result = new HashSet<String>();
        String nameFromDeployment = deploymentBuilder.getNameFromDeployment();
        if (nameFromDeployment != null && !nameFromDeployment.isEmpty()) {
            result.add(nameFromDeployment);
        }
        Set<String> deployments = deploymentBuilder.getDeployments();
        result.addAll(deployments);
        deployments = deploymentBuilder.getDeploymentResourcesById().keySet();
        result.addAll(deployments);
        deployments = deploymentBuilder.getDeploymentResourcesByName().keySet();
        result.addAll(deployments);
        return result;
    }

    protected void checkDuplicateResourceName(List<ResourceEntity> resources) {
        HashMap<String, ResourceEntity> resourceMap = new HashMap<String, ResourceEntity>();
        for (ResourceEntity resource : resources) {
            String deploymentId;
            String name = resource.getName();
            ResourceEntity duplicate = (ResourceEntity)resourceMap.get(name);
            if (duplicate != null && !(deploymentId = resource.getDeploymentId()).equals(duplicate.getDeploymentId())) {
                String message = "The deployments with id '%s' and '%s' contain a resource with same name '%s'.".formatted(deploymentId, duplicate.getDeploymentId(), name);
                throw new NotValidException(message);
            }
            resourceMap.put(name, resource);
        }
    }

    protected void checkCreateAndReadDeployments(CommandContext commandContext, Set<String> deploymentIds) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateDeployment();
            for (String deploymentId : deploymentIds) {
                checker.checkReadDeployment(deploymentId);
            }
        }
    }

    protected boolean isBpmnResource(Resource resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
    }

    protected boolean isCmmnResource(Resource resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
    }

    protected void ensureDeploymentsWithIdsExists(Set<String> expected, List<DeploymentEntity> actual) {
        HashMap<String, DeploymentEntity> deploymentMap = new HashMap<String, DeploymentEntity>();
        for (DeploymentEntity deployment : actual) {
            deploymentMap.put(deployment.getId(), deployment);
        }
        List<String> missingDeployments = this.getMissingElements(expected, deploymentMap);
        if (!missingDeployments.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("The following deployments are not found by id: ");
            builder.append(StringUtil.join(missingDeployments.iterator()));
            throw new NotFoundException(builder.toString());
        }
    }

    protected void ensureResourcesWithIdsExist(String deploymentId, Set<String> expectedIds, List<ResourceEntity> actual) {
        HashMap<String, ResourceEntity> resources = new HashMap<String, ResourceEntity>();
        for (ResourceEntity resource : actual) {
            resources.put(resource.getId(), resource);
        }
        this.ensureResourcesWithKeysExist(deploymentId, expectedIds, resources, "id");
    }

    protected void ensureResourcesWithNamesExist(String deploymentId, Set<String> expectedNames, List<ResourceEntity> actual) {
        HashMap<String, ResourceEntity> resources = new HashMap<String, ResourceEntity>();
        for (ResourceEntity resource : actual) {
            resources.put(resource.getName(), resource);
        }
        this.ensureResourcesWithKeysExist(deploymentId, expectedNames, resources, "name");
    }

    protected void ensureResourcesWithKeysExist(String deploymentId, Set<String> expectedKeys, Map<String, ResourceEntity> actual, String valueProperty) {
        List<String> missingResources = this.getMissingElements(expectedKeys, actual);
        if (!missingResources.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("The deployment with id '");
            builder.append(deploymentId);
            builder.append("' does not contain the following resources with ");
            builder.append(valueProperty);
            builder.append(": ");
            builder.append(StringUtil.join(missingResources.iterator()));
            throw new NotFoundException(builder.toString());
        }
    }
}

