/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Date;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.batch.SetJobRetriesBatchConfiguration;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetJobsRetriesBatchCmd
implements Command<Batch> {
    protected int retries;
    protected Date dueDate;
    protected boolean isDueDateSet;

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectJobIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "jobIds", elementConfiguration.getIds());
        EnsureUtil.ensureGreaterThanOrEqual("Retries count", this.retries, 0L);
        if (this.dueDate == null && commandContext.getProcessEngineConfiguration().isEnsureJobDueDateNotNull()) {
            this.dueDate = ClockUtil.getCurrentTime();
        }
        return new BatchBuilder(commandContext).config(this.getConfiguration(elementConfiguration)).type("set-job-retries").permission(BatchPermissions.CREATE_BATCH_SET_JOB_RETRIES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("retries", null, this.retries));
        commandContext.getOperationLogManager().logJobOperation("SetJobRetries", null, null, null, null, null, propertyChanges);
    }

    protected abstract BatchElementConfiguration collectJobIds(CommandContext var1);

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new SetJobRetriesBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.retries, this.dueDate, this.isDueDateSet);
    }
}

