/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cfg;

import java.io.InputStream;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public final class BeansConfigurationHelper {
    private BeansConfigurationHelper() {
    }

    public static ProcessEngineConfiguration parseProcessEngineConfiguration(Resource springResource, String beanName) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmlBeanDefinitionReader.setValidationMode(3);
        xmlBeanDefinitionReader.loadBeanDefinitions(springResource);
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)beanFactory.getBean(beanName);
        if (processEngineConfiguration.getBeans() == null) {
            processEngineConfiguration.setBeans(new SpringBeanFactoryProxyMap((BeanFactory)beanFactory));
        }
        return processEngineConfiguration;
    }

    public static ProcessEngineConfiguration parseProcessEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        InputStreamResource springResource = new InputStreamResource(inputStream);
        return BeansConfigurationHelper.parseProcessEngineConfiguration((Resource)springResource, beanName);
    }

    public static ProcessEngineConfiguration parseProcessEngineConfigurationFromResource(String resource, String beanName) {
        ClassPathResource springResource = new ClassPathResource(resource);
        return BeansConfigurationHelper.parseProcessEngineConfiguration((Resource)springResource, beanName);
    }
}

