/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.parser;

import java.io.Serializable;
import java.util.Comparator;
import javax.script.ScriptException;
import org.operaton.bpm.engine.ProcessEngineException;

public class ErrorEventDefinition
implements Serializable {
    public static final Comparator<ErrorEventDefinition> comparator = (o1, o2) -> o2.getPrecedence().compareTo(o1.getPrecedence());
    private static final long serialVersionUID = 1L;
    protected final String handlerActivityId;
    protected String errorCode;
    protected Integer precedence = 0;
    protected String errorCodeVariable;
    protected String errorMessageVariable;

    public ErrorEventDefinition(String handlerActivityId) {
        this.handlerActivityId = handlerActivityId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getHandlerActivityId() {
        return this.handlerActivityId;
    }

    public Integer getPrecedence() {
        return this.precedence + (this.errorCode != null ? 1 : 0);
    }

    public void setPrecedence(Integer precedence) {
        this.precedence = precedence;
    }

    public boolean catchesError(String errorCode) {
        return this.errorCode == null || this.errorCode.equals(errorCode);
    }

    public boolean catchesException(Exception ex) {
        if (this.errorCode == null) {
            return false;
        }
        while ((ex instanceof ProcessEngineException || ex instanceof ScriptException) && ex.getCause() != null) {
            ex = (Exception)ex.getCause();
        }
        Class<?> exceptionClass = ex.getClass();
        do {
            if (!this.errorCode.equals(exceptionClass.getName())) continue;
            return true;
        } while ((exceptionClass = exceptionClass.getSuperclass()) != null);
        return false;
    }

    public void setErrorCodeVariable(String errorCodeVariable) {
        this.errorCodeVariable = errorCodeVariable;
    }

    public String getErrorCodeVariable() {
        return this.errorCodeVariable;
    }

    public void setErrorMessageVariable(String errorMessageVariable) {
        this.errorMessageVariable = errorMessageVariable;
    }

    public String getErrorMessageVariable() {
        return this.errorMessageVariable;
    }
}

