/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.helper;

import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.BpmnError;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.helper.ErrorDeclarationForProcessInstanceFinder;
import org.operaton.bpm.engine.impl.bpmn.helper.ErrorPropagationException;
import org.operaton.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.tree.ActivityExecutionHierarchyWalker;
import org.operaton.bpm.engine.impl.tree.ActivityExecutionMappingCollector;
import org.operaton.bpm.engine.impl.tree.OutputVariablesPropagator;

public final class BpmnExceptionHandler {
    private static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    private BpmnExceptionHandler() {
    }

    public static void propagateException(ActivityExecution execution, Exception ex) throws Exception {
        BpmnError bpmnError = BpmnExceptionHandler.checkIfCauseOfExceptionIsBpmnError(ex);
        if (bpmnError != null) {
            BpmnExceptionHandler.propagateBpmnError(bpmnError, execution);
        } else {
            BpmnExceptionHandler.propagateExceptionAsError(ex, execution);
        }
    }

    protected static void propagateExceptionAsError(Exception exception, ActivityExecution execution) throws Exception {
        if (BpmnExceptionHandler.isProcessEngineExceptionWithoutCause(exception) || BpmnExceptionHandler.isTransactionNotActive()) {
            throw exception;
        }
        BpmnExceptionHandler.propagateError(null, exception.getMessage(), exception, execution);
    }

    protected static boolean isTransactionNotActive() {
        return !Context.getCommandContext().getTransactionContext().isTransactionActive();
    }

    protected static boolean isProcessEngineExceptionWithoutCause(Exception exception) {
        return exception instanceof ProcessEngineException && exception.getCause() == null;
    }

    protected static BpmnError checkIfCauseOfExceptionIsBpmnError(Throwable e) {
        if (e instanceof BpmnError) {
            BpmnError bpmnError = (BpmnError)e;
            return bpmnError;
        }
        if (e.getCause() == null) {
            return null;
        }
        return BpmnExceptionHandler.checkIfCauseOfExceptionIsBpmnError(e.getCause());
    }

    public static void propagateBpmnError(BpmnError error, ActivityExecution execution) throws Exception {
        BpmnExceptionHandler.propagateError(error.getErrorCode(), error.getMessage(), null, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void propagateError(String errorCode, String errorMessage, Exception origException, ActivityExecution execution) throws Exception {
        ActivityExecutionHierarchyWalker walker = new ActivityExecutionHierarchyWalker(execution);
        ErrorDeclarationForProcessInstanceFinder errorDeclarationFinder = new ErrorDeclarationForProcessInstanceFinder(origException, errorCode, execution.getActivity());
        ActivityExecutionMappingCollector activityExecutionMappingCollector = new ActivityExecutionMappingCollector(execution);
        walker.addScopePreVisitor(errorDeclarationFinder);
        walker.addExecutionPreVisitor(activityExecutionMappingCollector);
        walker.addExecutionPreVisitor(new OutputVariablesPropagator());
        try {
            walker.walkUntil(element -> errorDeclarationFinder.getErrorEventDefinition() != null || element == null);
        }
        catch (Exception e) {
            LOG.errorPropagationException(execution.getActivityInstanceId(), e);
            throw new ErrorPropagationException(e.getCause());
        }
        PvmActivity errorHandlingActivity = errorDeclarationFinder.getErrorHandlerActivity();
        if (errorHandlingActivity == null) {
            if (origException != null) throw origException;
            if (Context.getCommandContext().getProcessEngineConfiguration().isEnableExceptionsAfterUnhandledBpmnError()) {
                throw LOG.missingBoundaryCatchEventError(execution.getActivity().getId(), errorCode, errorMessage);
            }
            LOG.missingBoundaryCatchEvent(execution.getActivity().getId(), errorCode, errorMessage);
            execution.end(true);
            return;
        } else {
            ErrorEventDefinition errorDefinition = errorDeclarationFinder.getErrorEventDefinition();
            PvmExecutionImpl errorHandlingExecution = activityExecutionMappingCollector.getExecutionForScope(errorHandlingActivity.getEventScope());
            if (errorDefinition.getErrorCodeVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorCodeVariable(), errorCode);
            }
            if (errorDefinition.getErrorMessageVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorMessageVariable(), errorMessage);
            }
            errorHandlingExecution.executeActivity(errorHandlingActivity);
        }
    }
}

