/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.RestartProcessInstanceBuilderImpl;
import org.operaton.bpm.engine.impl.RestartProcessInstancesBatchConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.DeploymentMapping;
import org.operaton.bpm.engine.impl.batch.DeploymentMappings;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.operaton.bpm.engine.impl.cmd.AbstractRestartProcessInstanceCmd;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class RestartProcessInstancesBatchCmd
extends AbstractRestartProcessInstanceCmd<Batch> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    public RestartProcessInstancesBatchCmd(CommandExecutor commandExecutor, RestartProcessInstanceBuilderImpl builder) {
        super(commandExecutor, builder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        Collection<String> collectedInstanceIds = this.collectProcessInstanceIds();
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getInstructions();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Restart instructions cannot be empty", "instructions", instructions);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "processInstanceIds", collectedInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "processInstanceIds", collectedInstanceIds);
        String processDefinitionId = this.builder.getProcessDefinitionId();
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, processDefinitionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process definition cannot be null", (Object)processDefinition);
        this.ensureTenantAuthorized(commandContext, processDefinition);
        String tenantId = processDefinition.getTenantId();
        return new BatchBuilder(commandContext).type("instance-restart").config(this.getConfiguration(collectedInstanceIds, processDefinition.getDeploymentId())).permission(BatchPermissions.CREATE_BATCH_RESTART_PROCESS_INSTANCES).tenantId(tenantId).operationLogHandler((ctx, instanceCount) -> this.writeUserOperationLog(ctx, processDefinition, instanceCount, true)).build();
    }

    protected void ensureTenantAuthorized(CommandContext commandContext, ProcessDefinitionEntity processDefinition) {
        if (!commandContext.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("restart process instances of process definition '" + processDefinition.getId() + "'");
        }
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds, String deploymentId) {
        return new RestartProcessInstancesBatchConfiguration(new ArrayList<String>(instanceIds), DeploymentMappings.of(new DeploymentMapping(deploymentId, instanceIds.size())), this.builder.getInstructions(), this.builder.getProcessDefinitionId(), this.builder.isInitialVariables(), this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings(), this.builder.isWithoutBusinessKey());
    }
}

