/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.batch;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class DeploymentMapping {
    protected static final String NULL_ID = "$NULL";
    protected String deploymentId;
    protected int count;

    public DeploymentMapping(String deploymentId, int count) {
        this.deploymentId = deploymentId == null ? NULL_ID : deploymentId;
        this.count = count;
    }

    public String getDeploymentId() {
        return NULL_ID.equals(this.deploymentId) ? null : this.deploymentId;
    }

    public int getCount() {
        return this.count;
    }

    public List<String> getIds(List<String> ids) {
        return ids.subList(0, this.count);
    }

    public void removeIds(int numberOfIds) {
        this.count -= numberOfIds;
    }

    public String toString() {
        return new StringJoiner(";").add(this.deploymentId).add(String.valueOf(this.count)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.count, this.deploymentId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeploymentMapping)) {
            return false;
        }
        DeploymentMapping other = (DeploymentMapping)obj;
        return this.count == other.count && Objects.equals(this.deploymentId, other.deploymentId);
    }
}

