/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.history.HistoricCaseActivityInstance;
import org.operaton.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.HistoricCaseActivityInstanceQueryProperty;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.CompareUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class HistoricCaseActivityInstanceQueryImpl
extends AbstractQuery<HistoricCaseActivityInstanceQuery, HistoricCaseActivityInstance>
implements HistoricCaseActivityInstanceQuery {
    private static final long serialVersionUID = 1L;
    private static final String CASE_ACTIVITY_STATE = "caseActivityState";
    protected String[] caseActivityInstanceIds;
    protected String[] caseActivityIds;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected String caseActivityName;
    protected String caseActivityType;
    protected Date createdBefore;
    protected Date createdAfter;
    protected Date endedBefore;
    protected Date endedAfter;
    protected Boolean ended;
    protected Integer caseActivityInstanceState;
    protected Boolean required;
    protected String[] tenantIds;
    protected boolean isTenantIdSet;

    public HistoricCaseActivityInstanceQueryImpl() {
    }

    public HistoricCaseActivityInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricCaseActivityInstanceManager().findHistoricCaseActivityInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricCaseActivityInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricCaseActivityInstanceManager().findHistoricCaseActivityInstancesByQueryCriteria(this, page);
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityInstanceId(String caseActivityInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityInstanceId", (Object)caseActivityInstanceId);
        return this.caseActivityInstanceIdIn(caseActivityInstanceId);
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityInstanceIdIn(String ... caseActivityInstanceIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityInstanceIds", (Object[])caseActivityInstanceIds);
        this.caseActivityInstanceIds = caseActivityInstanceIds;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionId", (Object)caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseExecutionId(String caseExecutionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseExecutionId", (Object)caseExecutionId);
        return this.caseActivityInstanceIdIn(caseExecutionId);
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityId(String caseActivityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityId", (Object)caseActivityId);
        return this.caseActivityIdIn(caseActivityId);
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityIdIn(String ... caseActivityIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityIds", (Object[])caseActivityIds);
        this.caseActivityIds = caseActivityIds;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityName(String caseActivityName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityName", (Object)caseActivityName);
        this.caseActivityName = caseActivityName;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityType(String caseActivityType) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityType", (Object)caseActivityType);
        this.caseActivityType = caseActivityType;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery createdBefore(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "createdBefore", (Object)date);
        this.createdBefore = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery createdAfter(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "createdAfter", (Object)date);
        this.createdAfter = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery endedBefore(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "finishedBefore", (Object)date);
        this.endedBefore = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery endedAfter(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "finishedAfter", (Object)date);
        this.endedAfter = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery required() {
        this.required = true;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery ended() {
        this.ended = true;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery notEnded() {
        this.ended = false;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery available() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.AVAILABLE.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery enabled() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.ENABLED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery disabled() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.DISABLED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery active() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.ACTIVE.getStateCode();
        return this;
    }

    public HistoricCaseActivityInstanceQuery suspended() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.SUSPENDED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery completed() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.COMPLETED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery terminated() {
        this.ensureCaseActivityInstanceStateIsNull();
        this.caseActivityInstanceState = CaseExecutionState.TERMINATED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", (Object[])tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.createdAfter, this.createdBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.endedAfter, this.endedBefore});
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.HISTORIC_CASE_ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseInstanceId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseExecutionId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.HISTORIC_CASE_ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseActivityId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseActivityName() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_ACTIVITY_NAME);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseActivityType() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_ACTIVITY_TYPE);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceCreateTime() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CREATE);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceEndTime() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.END);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceDuration() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseDefinitionId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByTenantId() {
        return (HistoricCaseActivityInstanceQuery)this.orderBy(HistoricCaseActivityInstanceQueryProperty.TENANT_ID);
    }

    public String[] getCaseActivityInstanceIds() {
        return this.caseActivityInstanceIds;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String[] getCaseActivityIds() {
        return this.caseActivityIds;
    }

    public String getCaseActivityName() {
        return this.caseActivityName;
    }

    public String getCaseActivityType() {
        return this.caseActivityType;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public Date getEndedBefore() {
        return this.endedBefore;
    }

    public Date getEndedAfter() {
        return this.endedAfter;
    }

    public Boolean getEnded() {
        return this.ended;
    }

    public Integer getCaseActivityInstanceState() {
        return this.caseActivityInstanceState;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    private void ensureCaseActivityInstanceStateIsNull() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", CASE_ACTIVITY_STATE, this.caseActivityInstanceState);
    }
}

