/*
 * Decompiled with CFR 0.152.
 */
package operatonjar.impl.com.cronutils.model.time.generator;

import operatonjar.impl.com.cronutils.mapper.WeekDay;
import operatonjar.impl.com.cronutils.model.field.CronField;
import operatonjar.impl.com.cronutils.model.field.expression.Always;
import operatonjar.impl.com.cronutils.model.field.expression.And;
import operatonjar.impl.com.cronutils.model.field.expression.Between;
import operatonjar.impl.com.cronutils.model.field.expression.Every;
import operatonjar.impl.com.cronutils.model.field.expression.FieldExpression;
import operatonjar.impl.com.cronutils.model.field.expression.On;
import operatonjar.impl.com.cronutils.model.field.value.SpecialChar;
import operatonjar.impl.com.cronutils.model.time.generator.AlwaysFieldValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.AndDayOfWeekValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.AndFieldValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.BetweenDayOfWeekValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.BetweenFieldValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.EveryDayOfWeekValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.EveryFieldValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.FieldValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.NullFieldValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.OnDayOfMonthValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.OnDayOfWeekValueGenerator;
import operatonjar.impl.com.cronutils.model.time.generator.OnFieldValueGenerator;

public class FieldValueGeneratorFactory {
    private FieldValueGeneratorFactory() {
    }

    public static FieldValueGenerator forCronField(CronField cronField) {
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof Always) {
            return new AlwaysFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof And) {
            return new AndFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof Between) {
            return new BetweenFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof Every) {
            return new EveryFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof On) {
            On on = (On)fieldExpression;
            if (!SpecialChar.NONE.equals((Object)on.getSpecialChar().getValue())) {
                throw new IllegalArgumentException(String.format("Cannot create instance for On instance with %s value", on.getSpecialChar()));
            }
            return new OnFieldValueGenerator(cronField);
        }
        return new NullFieldValueGenerator(cronField);
    }

    public static FieldValueGenerator createDayOfYearValueGeneratorInstance(CronField cronField, int year) {
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createDayOfMonthValueGeneratorInstance(CronField cronField, int year, int month) {
        On on;
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof On && !SpecialChar.NONE.equals((Object)(on = (On)fieldExpression).getSpecialChar().getValue())) {
            return new OnDayOfMonthValueGenerator(cronField, year, month);
        }
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createDayOfWeekValueGeneratorInstance(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof On) {
            return new OnDayOfWeekValueGenerator(cronField, year, month, mondayDoWValue);
        }
        if (fieldExpression instanceof Between) {
            return new BetweenDayOfWeekValueGenerator(cronField, year, month, mondayDoWValue);
        }
        if (fieldExpression instanceof And) {
            return new AndDayOfWeekValueGenerator(cronField, year, month, mondayDoWValue);
        }
        if (fieldExpression instanceof Every) {
            return new EveryDayOfWeekValueGenerator(cronField, year, month, mondayDoWValue);
        }
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createYearValueGeneratorInstance(CronField cronField) {
        return FieldValueGeneratorFactory.forCronField(cronField);
    }
}

