/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.List;
import java.util.function.Consumer;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.ProcessEngines;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.runtime.Job;
import org.operaton.bpm.engine.test.util.ProcessEngineUtils;

public class ProcessEngineBootstrapRule
extends TestWatcher {
    private String configurationResource;
    private ProcessEngine processEngine;
    protected Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator;

    public ProcessEngineBootstrapRule() {
        this("operaton.cfg.xml", config -> config.setProcessEngineName(ProcessEngineUtils.newRandomProcessEngineName()));
    }

    public ProcessEngineBootstrapRule(String configurationResource) {
        this(configurationResource, null);
    }

    public ProcessEngineBootstrapRule(Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator) {
        this("operaton.cfg.xml", processEngineConfigurator);
    }

    public ProcessEngineBootstrapRule(String configurationResource, Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator) {
        this.configurationResource = configurationResource;
        this.processEngineConfigurator = processEngineConfigurator;
    }

    public ProcessEngine bootstrapEngine(String configurationResource) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)configurationResource);
        this.configureEngine(processEngineConfiguration);
        if (ProcessEngines.isRegisteredProcessEngine((String)processEngineConfiguration.getProcessEngineName())) {
            processEngineConfiguration.setProcessEngineName(ProcessEngineUtils.newRandomProcessEngineName());
        }
        return processEngineConfiguration.buildProcessEngine();
    }

    public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
        if (this.processEngineConfigurator != null) {
            this.processEngineConfigurator.accept(configuration);
        }
        return configuration;
    }

    public ProcessEngine getProcessEngine() {
        if (this.processEngine == null) {
            this.processEngine = this.bootstrapEngine(this.configurationResource);
        }
        return this.processEngine;
    }

    protected void finished(Description description) {
        this.deleteHistoryCleanupJob();
        this.processEngine.close();
        ProcessEngines.unregister((ProcessEngine)this.processEngine);
        this.processEngine = null;
    }

    private void deleteHistoryCleanupJob() {
        List jobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        for (Job job : jobs) {
            ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute(commandContext -> {
                commandContext.getJobManager().deleteJob((JobEntity)job);
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                return null;
            });
        }
    }
}

