/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.runtime.Execution;
import org.operaton.bpm.engine.test.util.ExecutionTree;
import org.operaton.bpm.engine.test.util.ExecutionTreeAssertion;

public class ExecutionTreeProcessDefinitionIdAssertion
implements ExecutionTreeAssertion {
    protected String expectedProcessDefinitionId;

    @Override
    public void assertExecution(ExecutionTree tree) {
        List<Execution> nonMatchingExecutions = this.matches(tree);
        if (!nonMatchingExecutions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Expected all executions to have process definition id ").append(this.expectedProcessDefinitionId).append("\n");
            sb.append("Actual Tree: \n").append(tree).append("\nExecutions with unexpected process definition id:\n").append("[\n");
            for (Execution execution : nonMatchingExecutions) {
                sb.append(execution).append("\n");
            }
            sb.append("]\n");
            Assertions.fail((String)sb.toString());
        }
    }

    protected List<Execution> matches(ExecutionTree tree) {
        ExecutionEntity executionEntity = (ExecutionEntity)tree.getExecution();
        ArrayList<Execution> unmatchedExecutions = new ArrayList<Execution>();
        if (!this.expectedProcessDefinitionId.equals(executionEntity.getProcessDefinitionId())) {
            unmatchedExecutions.add(tree.getExecution());
        }
        for (ExecutionTree child : tree.getExecutions()) {
            unmatchedExecutions.addAll(this.matches(child));
        }
        return unmatchedExecutions;
    }

    public static ExecutionTreeProcessDefinitionIdAssertion processDefinitionId(String expectedProcessDefinitionId) {
        ExecutionTreeProcessDefinitionIdAssertion assertion = new ExecutionTreeProcessDefinitionIdAssertion();
        assertion.expectedProcessDefinitionId = expectedProcessDefinitionId;
        return assertion;
    }
}

