/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.batch.history.HistoricBatch;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.runtime.Job;
import org.operaton.bpm.engine.test.ProcessEngineRule;
import org.operaton.bpm.engine.test.util.ProcessEngineTestRule;

public class BatchRule
extends TestWatcher {
    public static final String SEED_JOB = "seed-job";
    public static final String MONITOR_JOB = "monitor-job";
    public static final String EXECUTION_JOBS = "execution-job";
    protected ProcessEngineRule engineRule;
    protected ProcessEngineTestRule engineTestRule;
    protected List<String> batchIds = new ArrayList<String>();

    public BatchRule(ProcessEngineRule engineRule, ProcessEngineTestRule engineTestRule) {
        this.engineRule = engineRule;
        this.engineTestRule = engineTestRule;
    }

    protected void finished(Description description) {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        ClockUtil.reset();
        this.clearDatabase();
    }

    public void clearDatabase() {
        if (!this.batchIds.isEmpty()) {
            for (String batchId : this.batchIds) {
                Batch batch;
                HistoricBatch historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().batchId(batchId).singleResult();
                if (historicBatch != null) {
                    this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
                }
                if ((batch = (Batch)this.engineRule.getManagementService().createBatchQuery().batchId(batchId).singleResult()) == null) continue;
                this.engineRule.getManagementService().deleteBatch(batchId, true);
            }
        }
    }

    public Map<String, List<Job>> syncExec(Batch batch) {
        return this.syncExec(batch, true);
    }

    public Map<String, List<Job>> syncExec(Batch batch, boolean isClear) {
        HashMap<String, List<Job>> processedJobs = new HashMap<String, List<Job>>();
        ArrayList<Job> processedSeedJobs = new ArrayList<Job>();
        if (isClear) {
            this.batchIds.add(batch.getId());
        }
        processedSeedJobs.addAll(this.executeSeedJobs(batch));
        processedJobs.put(SEED_JOB, processedSeedJobs);
        ArrayList<Job> processedExecutionJobs = new ArrayList<Job>();
        List<Job> jobs = this.getExecutionJobs(batch);
        while (!jobs.isEmpty()) {
            for (Job job : jobs) {
                this.engineRule.getManagementService().executeJob(job.getId());
                processedExecutionJobs.add(job);
            }
            jobs = this.getExecutionJobs(batch);
        }
        processedJobs.put(EXECUTION_JOBS, processedExecutionJobs);
        ArrayList<Job> processedMonitorJobs = new ArrayList<Job>();
        Job monitorJob = this.getJobForDefinition(batch.getMonitorJobDefinitionId());
        this.engineRule.getManagementService().executeJob(monitorJob.getId());
        processedMonitorJobs.add(monitorJob);
        processedJobs.put(MONITOR_JOB, processedMonitorJobs);
        return processedJobs;
    }

    public List<Job> executeSeedJobs(Batch batch) {
        return this.executeSeedJobs(batch, false);
    }

    public List<Job> executeSeedJobs(Batch batch, boolean cleanUp) {
        ArrayList<Job> processedJobs = new ArrayList<Job>();
        if (cleanUp) {
            this.batchIds.add(batch.getId());
        }
        while (this.getSeedJob(batch) != null) {
            Job seedJob = this.getSeedJob(batch);
            this.engineRule.getManagementService().executeJob(seedJob.getId());
            processedJobs.add(seedJob);
        }
        return processedJobs;
    }

    public Job getSeedJob(Batch batch) {
        return this.getJobForDefinition(batch.getSeedJobDefinitionId());
    }

    protected Job getJobForDefinition(String definitionId) {
        return (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(definitionId).singleResult();
    }

    public List<Job> getExecutionJobs(Batch batch) {
        return this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
    }
}

