/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.runtime.migration;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.operaton.bpm.engine.RuntimeService;
import org.operaton.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.management.JobDefinition;
import org.operaton.bpm.engine.migration.MigrationPlan;
import org.operaton.bpm.engine.runtime.ActivityInstance;
import org.operaton.bpm.engine.runtime.EventSubscription;
import org.operaton.bpm.engine.runtime.Job;
import org.operaton.bpm.engine.runtime.ProcessInstance;
import org.operaton.bpm.engine.runtime.VariableInstance;
import org.operaton.bpm.engine.test.ProcessEngineRule;
import org.operaton.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshot;
import org.operaton.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshotBuilder;
import org.operaton.bpm.engine.test.util.ActivityInstanceAssert;
import org.operaton.bpm.engine.test.util.ExecutionAssert;
import org.operaton.bpm.engine.test.util.ProcessEngineTestRule;

public class MigrationTestRule
extends ProcessEngineTestRule {
    public ProcessInstanceSnapshot snapshotBeforeMigration;
    public ProcessInstanceSnapshot snapshotAfterMigration;

    public MigrationTestRule(ProcessEngineRule processEngineRule) {
        super(processEngineRule);
    }

    public String getSingleExecutionIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance singleInstance = this.getSingleActivityInstance(activityInstance, activityId);
        String[] executionIds = singleInstance.getExecutionIds();
        if (executionIds.length == 1) {
            return executionIds[0];
        }
        throw new RuntimeException("There is more than one execution assigned to activity instance " + singleInstance.getId());
    }

    public String getSingleExecutionIdForActivityBeforeMigration(String activityId) {
        return this.getSingleExecutionIdForActivity(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public String getSingleExecutionIdForActivityAfterMigration(String activityId) {
        return this.getSingleExecutionIdForActivity(this.snapshotAfterMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstance(ActivityInstance tree, String activityId) {
        ActivityInstance[] activityInstances = tree.getActivityInstances(activityId);
        if (activityInstances.length == 1) {
            return activityInstances[0];
        }
        throw new RuntimeException("There is not exactly one activity instance for activity " + activityId);
    }

    public ActivityInstance getSingleActivityInstanceBeforeMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstanceAfterMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotAfterMigration.getActivityTree(), activityId);
    }

    public ProcessInstanceSnapshot takeFullProcessInstanceSnapshot(ProcessInstance processInstance) {
        return this.takeProcessInstanceSnapshot(processInstance).full();
    }

    public ProcessInstanceSnapshotBuilder takeProcessInstanceSnapshot(ProcessInstance processInstance) {
        return new ProcessInstanceSnapshotBuilder(processInstance, this.processEngine);
    }

    public ProcessInstance createProcessInstanceAndMigrate(MigrationPlan migrationPlan) {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.migrateProcessInstance(migrationPlan, processInstance);
        return processInstance;
    }

    public ProcessInstance createProcessInstanceAndMigrate(MigrationPlan migrationPlan, Map<String, Object> variables) {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId(), variables);
        this.migrateProcessInstance(migrationPlan, processInstance);
        return processInstance;
    }

    public void migrateProcessInstance(MigrationPlan migrationPlan, ProcessInstance processInstance) {
        this.snapshotBeforeMigration = this.takeFullProcessInstanceSnapshot(processInstance);
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(this.snapshotBeforeMigration.getProcessInstanceId())).execute();
        processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        this.snapshotAfterMigration = this.takeFullProcessInstanceSnapshot(processInstance);
    }

    public void triggerTimer() {
        Job job = this.assertTimerJobExists(this.snapshotAfterMigration);
        this.processEngine.getManagementService().executeJob(job.getId());
    }

    public ExecutionAssert assertExecutionTreeAfterMigration() {
        return ExecutionAssert.assertThat(this.snapshotAfterMigration.getExecutionTree());
    }

    public ActivityInstanceAssert.ActivityInstanceAssertThatClause assertActivityTreeAfterMigration() {
        return ActivityInstanceAssert.assertThat(this.snapshotAfterMigration.getActivityTree());
    }

    public void assertEventSubscriptionsMigrated(String activityIdBefore, String activityIdAfter, String eventName) {
        List eventSubscriptionsBefore = this.snapshotBeforeMigration.getEventSubscriptionsForActivityIdAndEventName(activityIdAfter, eventName);
        for (EventSubscription eventSubscription : eventSubscriptionsBefore) {
            this.assertEventSubscriptionMigrated(eventSubscription, activityIdAfter, eventName);
        }
    }

    protected void assertEventSubscriptionMigrated(EventSubscription eventSubscriptionBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionAfter = this.snapshotAfterMigration.getEventSubscriptionById(eventSubscriptionBefore.getId());
        ((ObjectAssert)Assertions.assertThat((Object)eventSubscriptionAfter).as("Expected that an event subscription with id '" + eventSubscriptionBefore.getId() + "' exists after migration", new Object[0])).isNotNull();
        Assertions.assertThat((String)eventSubscriptionAfter.getEventType()).isEqualTo(eventSubscriptionBefore.getEventType());
        Assertions.assertThat((String)eventSubscriptionAfter.getActivityId()).isEqualTo(activityIdAfter);
        Assertions.assertThat((String)eventSubscriptionAfter.getEventName()).isEqualTo(eventName);
    }

    public void assertEventSubscriptionMigrated(String activityIdBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityIdBefore, eventName);
        ((ObjectAssert)Assertions.assertThat((Object)eventSubscriptionBefore).as("Expected that an event subscription for activity '" + activityIdBefore + "' exists before migration", new Object[0])).isNotNull();
        this.assertEventSubscriptionMigrated(eventSubscriptionBefore, activityIdAfter, eventName);
    }

    public void assertEventSubscriptionMigrated(String activityIdBefore, String eventNameBefore, String activityIdAfter, String eventNameAfter) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityIdBefore, eventNameBefore);
        ((ObjectAssert)Assertions.assertThat((Object)eventSubscriptionBefore).as("Expected that an event subscription for activity '" + activityIdBefore + "' exists before migration", new Object[0])).isNotNull();
        this.assertEventSubscriptionMigrated(eventSubscriptionBefore, activityIdAfter, eventNameAfter);
    }

    public void assertEventSubscriptionRemoved(String activityId, String eventName) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        ((ObjectAssert)Assertions.assertThat((Object)eventSubscriptionBefore).as("Expected an event subscription for activity '" + activityId + "' before the migration", new Object[0])).isNotNull();
        for (EventSubscription eventSubscription : this.snapshotAfterMigration.getEventSubscriptions()) {
            if (!eventSubscriptionBefore.getId().equals(eventSubscription.getId())) continue;
            Assertions.fail((String)("Expected event subscription '" + eventSubscriptionBefore.getId() + "' to be removed after migration"));
        }
    }

    public void assertEventSubscriptionCreated(String activityId, String eventName) {
        EventSubscription eventSubscriptionAfter = this.snapshotAfterMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        ((ObjectAssert)Assertions.assertThat((Object)eventSubscriptionAfter).as("Expected an event subscription for activity '" + activityId + "' after the migration", new Object[0])).isNotNull();
        for (EventSubscription eventSubscription : this.snapshotBeforeMigration.getEventSubscriptions()) {
            if (!eventSubscriptionAfter.getId().equals(eventSubscription.getId())) continue;
            Assertions.fail((String)("Expected event subscription '" + eventSubscriptionAfter.getId() + "' to be created after migration"));
        }
    }

    public void assertTimerJob(Job job) {
        ((AbstractStringAssert)Assertions.assertThat((String)((JobEntity)job).getType()).as("Expected job to be a timer job", new Object[0])).isEqualTo("timer");
    }

    public Job assertTimerJobExists(ProcessInstanceSnapshot snapshot) {
        List jobs = snapshot.getJobs();
        Assertions.assertThat((List)jobs).hasSize(1);
        Job job = (Job)jobs.get(0);
        this.assertTimerJob(job);
        return job;
    }

    public void assertJobCreated(String activityId, String handlerType) {
        JobDefinition jobDefinitionAfter = this.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityId, handlerType);
        ((ObjectAssert)Assertions.assertThat((Object)jobDefinitionAfter).as("Expected that a job definition for activity '" + activityId + "' exists after migration", new Object[0])).isNotNull();
        Job jobAfter = this.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
        ((ObjectAssert)Assertions.assertThat((Object)jobAfter).as("Expected that a job for activity '" + activityId + "' exists after migration", new Object[0])).isNotNull();
        this.assertTimerJob(jobAfter);
        Assertions.assertThat((String)jobAfter.getProcessDefinitionId()).isEqualTo(jobDefinitionAfter.getProcessDefinitionId());
        Assertions.assertThat((String)jobAfter.getProcessDefinitionKey()).isEqualTo(jobDefinitionAfter.getProcessDefinitionKey());
        for (Job job : this.snapshotBeforeMigration.getJobs()) {
            if (!jobAfter.getId().equals(job.getId())) continue;
            Assertions.fail((String)("Expected job '" + jobAfter.getId() + "' to be created first after migration"));
        }
    }

    public void assertJobsCreated(String activityId, String handlerType, int countJobs) {
        List jobDefinitionsAfter = this.snapshotAfterMigration.getJobDefinitionsForActivityIdAndType(activityId, handlerType);
        ((ListAssert)Assertions.assertThat((List)jobDefinitionsAfter).as("Expected that " + countJobs + "job definitions for activity '" + activityId + "' exist after migration, but found " + jobDefinitionsAfter.size(), new Object[0])).hasSize(countJobs);
        for (JobDefinition jobDefinitionAfter : jobDefinitionsAfter) {
            Job jobAfter = this.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
            ((ObjectAssert)Assertions.assertThat((Object)jobAfter).as("Expected that a job for activity '" + activityId + "' exists after migration", new Object[0])).isNotNull();
            this.assertTimerJob(jobAfter);
            Assertions.assertThat((String)jobAfter.getProcessDefinitionId()).isEqualTo(jobDefinitionAfter.getProcessDefinitionId());
            Assertions.assertThat((String)jobAfter.getProcessDefinitionKey()).isEqualTo(jobDefinitionAfter.getProcessDefinitionKey());
            for (Job job : this.snapshotBeforeMigration.getJobs()) {
                if (!jobAfter.getId().equals(job.getId())) continue;
                Assertions.fail((String)("Expected job '" + jobAfter.getId() + "' to be created first after migration"));
            }
        }
    }

    public void assertJobRemoved(String activityId, String handlerType) {
        JobDefinition jobDefinitionBefore = this.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType(activityId, handlerType);
        ((ObjectAssert)Assertions.assertThat((Object)jobDefinitionBefore).as("Expected that a job definition for activity '" + activityId + "' exists before migration", new Object[0])).isNotNull();
        Job jobBefore = this.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        ((ObjectAssert)Assertions.assertThat((Object)jobBefore).as("Expected that a job for activity '" + activityId + "' exists before migration", new Object[0])).isNotNull();
        this.assertTimerJob(jobBefore);
        for (Job job : this.snapshotAfterMigration.getJobs()) {
            if (!jobBefore.getId().equals(job.getId())) continue;
            Assertions.fail((String)("Expected job '" + jobBefore.getId() + "' to be removed after migration"));
        }
    }

    public void assertJobMigrated(String activityIdBefore, String activityIdAfter, String handlerType) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, handlerType, null);
    }

    public void assertJobMigrated(String activityIdBefore, String activityIdAfter, String handlerType, Date dueDateAfter) {
        JobDefinition jobDefinitionBefore = this.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType(activityIdBefore, handlerType);
        ((ObjectAssert)Assertions.assertThat((Object)jobDefinitionBefore).as("Expected that a job definition for activity '" + activityIdBefore + "' exists before migration", new Object[0])).isNotNull();
        Job jobBefore = this.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        ((ObjectAssert)Assertions.assertThat((Object)jobBefore).as("Expected that a timer job for activity '" + activityIdBefore + "' exists before migration", new Object[0])).isNotNull();
        this.assertJobMigrated(jobBefore, activityIdAfter, dueDateAfter == null ? jobBefore.getDuedate() : dueDateAfter);
    }

    public void assertJobMigrated(Job jobBefore, String activityIdAfter) {
        this.assertJobMigrated(jobBefore, activityIdAfter, jobBefore.getDuedate());
    }

    public void assertJobMigrated(Job jobBefore, String activityIdAfter, Date dueDateAfter) {
        Job jobAfter = this.snapshotAfterMigration.getJobById(jobBefore.getId());
        ((ObjectAssert)Assertions.assertThat((Object)jobAfter).as("Expected that a job with id '" + jobBefore.getId() + "' exists after migration", new Object[0])).isNotNull();
        JobDefinition jobDefinitionAfter = this.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityIdAfter, ((JobEntity)jobBefore).getJobHandlerType());
        ((ObjectAssert)Assertions.assertThat((Object)jobDefinitionAfter).as("Expected that a job definition for activity '" + activityIdAfter + "' exists after migration", new Object[0])).isNotNull();
        Assertions.assertThat((String)jobAfter.getId()).isEqualTo(jobBefore.getId());
        ((AbstractStringAssert)Assertions.assertThat((String)jobAfter.getJobDefinitionId()).as("Expected that job is assigned to job definition '" + jobDefinitionAfter.getId() + "' after migration", new Object[0])).isEqualTo(jobDefinitionAfter.getId());
        ((AbstractStringAssert)Assertions.assertThat((String)jobAfter.getDeploymentId()).as("Expected that job is assigned to deployment '" + this.snapshotAfterMigration.getDeploymentId() + "' after migration", new Object[0])).isEqualTo(this.snapshotAfterMigration.getDeploymentId());
        Assertions.assertThat((Date)jobAfter.getDuedate()).isEqualTo((Object)dueDateAfter);
        Assertions.assertThat((String)((JobEntity)jobAfter).getType()).isEqualTo(((JobEntity)jobBefore).getType());
        Assertions.assertThat((long)jobAfter.getPriority()).isEqualTo(jobBefore.getPriority());
        Assertions.assertThat((String)jobAfter.getProcessDefinitionId()).isEqualTo(jobDefinitionAfter.getProcessDefinitionId());
        Assertions.assertThat((String)jobAfter.getProcessDefinitionKey()).isEqualTo(jobDefinitionAfter.getProcessDefinitionKey());
    }

    public void assertBoundaryTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-transition");
    }

    public void assertBoundaryTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-transition");
    }

    public void assertBoundaryTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-transition");
    }

    public void assertIntermediateTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-intermediate-transition");
    }

    public void assertIntermediateTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-intermediate-transition");
    }

    public void assertIntermediateTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-intermediate-transition");
    }

    public void assertEventSubProcessTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-start-event-subprocess");
    }

    public void assertEventSubProcessTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-start-event-subprocess");
    }

    public void assertTaskListenerTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-task-listener");
    }

    public void assertTaskListenerTimerJobsCreated(String activityId, int countJobs) {
        this.assertJobsCreated(activityId, "timer-task-listener", countJobs);
    }

    public void assertTaskListenerTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-task-listener");
    }

    public void assertTaskListenerTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-task-listener");
    }

    public void assertTaskListenerTimerJobMigrated(String activityIdBefore, String activityIdAfter, Date dueDateAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-task-listener", dueDateAfter);
    }

    public void assertVariableMigratedToExecution(VariableInstance variableBefore, String executionId) {
        this.assertVariableMigratedToExecution(variableBefore, executionId, variableBefore.getActivityInstanceId());
    }

    public void assertVariableMigratedToExecution(VariableInstance variableBefore, String executionId, String activityInstanceId) {
        VariableInstance variableAfter = this.snapshotAfterMigration.getVariable(variableBefore.getId());
        ((ObjectAssert)Assertions.assertThat((Object)variableAfter).as("Variable with id " + variableBefore.getId() + " does not exist", new Object[0])).isNotNull();
        Assertions.assertThat((String)variableAfter.getActivityInstanceId()).isEqualTo(activityInstanceId);
        Assertions.assertThat((String)variableAfter.getCaseExecutionId()).isEqualTo(variableBefore.getCaseExecutionId());
        Assertions.assertThat((String)variableAfter.getCaseInstanceId()).isEqualTo(variableBefore.getCaseInstanceId());
        Assertions.assertThat((String)variableAfter.getErrorMessage()).isEqualTo(variableBefore.getErrorMessage());
        Assertions.assertThat((String)variableAfter.getExecutionId()).isEqualTo(executionId);
        Assertions.assertThat((String)variableAfter.getId()).isEqualTo(variableBefore.getId());
        Assertions.assertThat((String)variableAfter.getName()).isEqualTo(variableBefore.getName());
        Assertions.assertThat((String)variableAfter.getProcessInstanceId()).isEqualTo(variableBefore.getProcessInstanceId());
        Assertions.assertThat((String)variableAfter.getTaskId()).isEqualTo(variableBefore.getTaskId());
        Assertions.assertThat((String)variableAfter.getTenantId()).isEqualTo(variableBefore.getTenantId());
        Assertions.assertThat((String)variableAfter.getTypeName()).isEqualTo(variableBefore.getTypeName());
        Assertions.assertThat((Object)variableAfter.getValue()).isEqualTo(variableBefore.getValue());
    }

    public void assertSuperExecutionOfCaseInstance(String caseInstanceId, String expectedSuperExecutionId) {
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assertions.assertThat((String)calledInstance.getSuperExecutionId()).isEqualTo(expectedSuperExecutionId);
    }

    public void assertSuperExecutionOfProcessInstance(String processInstance, String expectedSuperExecutionId) {
        ExecutionEntity calledInstance = (ExecutionEntity)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance).singleResult();
        Assertions.assertThat((String)calledInstance.getSuperExecutionId()).isEqualTo(expectedSuperExecutionId);
    }
}

