/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.authorization.util;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.MissingAuthorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.impl.util.ResourceTypeUtil;

public final class AuthorizationTestUtil {
    protected static Map<Integer, Resource> resourcesByType = new HashMap<Integer, Resource>();

    public static Resource getResourceByType(int type) {
        return resourcesByType.get(type);
    }

    public static void assertExceptionInfo(String expectedPermissionName, String expectedResourceName, String expectedResourceId, MissingAuthorization info) {
        Assertions.assertThat((String)info.getViolatedPermissionName()).isEqualTo(expectedPermissionName);
        Assertions.assertThat((String)info.getResourceType()).isEqualTo(expectedResourceName);
        Assertions.assertThat((String)info.getResourceId()).isEqualTo(expectedResourceId);
    }

    public static Permission[] getPermissions(Authorization authorization) {
        int resourceType = authorization.getResourceType();
        Permission[] permissionsByResourceType = ResourceTypeUtil.getPermissionsByResourceType((int)resourceType);
        return authorization.getPermissions(permissionsByResourceType);
    }

    private AuthorizationTestUtil() {
    }

    static {
        for (Resources resource : Resources.values()) {
            resourcesByType.put(resource.resourceType(), (Resource)resource);
        }
    }
}

