/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.authorization.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.runner.Description;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;
import org.operaton.bpm.engine.test.ProcessEngineRule;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationExceptionInterceptor;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationScenarioInstance;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;

public class AuthorizationTestRule
extends AuthorizationTestBaseRule {
    protected AuthorizationExceptionInterceptor interceptor = new AuthorizationExceptionInterceptor();
    protected CommandExecutor replacedCommandExecutor;
    protected AuthorizationScenarioInstance scenarioInstance;

    public AuthorizationTestRule(ProcessEngineRule engineRule) {
        super(engineRule);
    }

    public void start(AuthorizationScenario scenario) {
        this.start(scenario, null, new HashMap<String, String>());
    }

    public void start(AuthorizationScenario scenario, String userId, Map<String, String> resourceBindings) {
        Assertions.assertThat((Throwable)this.interceptor.getLastException()).isNull();
        this.scenarioInstance = new AuthorizationScenarioInstance(scenario, this.engineRule.getAuthorizationService(), resourceBindings);
        this.enableAuthorization(userId);
        this.interceptor.activate();
    }

    public boolean assertScenario(AuthorizationScenario scenario) {
        this.interceptor.deactivate();
        this.disableAuthorization();
        this.scenarioInstance.tearDown(this.engineRule.getAuthorizationService());
        this.scenarioInstance.assertAuthorizationException(this.interceptor.getLastException());
        this.scenarioInstance = null;
        return this.scenarioSucceeded();
    }

    public boolean scenarioSucceeded() {
        return this.interceptor.getLastException() == null;
    }

    public boolean scenarioFailed() {
        return this.interceptor.getLastException() != null;
    }

    protected void starting(Description description) {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        this.interceptor.reset();
        ((CommandInterceptor)engineConfiguration.getCommandInterceptorsTxRequired().get(0)).setNext((CommandExecutor)this.interceptor);
        this.interceptor.setNext((CommandExecutor)engineConfiguration.getCommandInterceptorsTxRequired().get(1));
        super.starting(description);
    }

    @Override
    protected void finished(Description description) {
        super.finished(description);
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        ((CommandInterceptor)engineConfiguration.getCommandInterceptorsTxRequired().get(0)).setNext(this.interceptor.getNext());
        this.interceptor.setNext(null);
    }

    public static Collection<AuthorizationScenario[]> asParameters(AuthorizationScenario ... scenarios) {
        ArrayList<AuthorizationScenario[]> scenarioList = new ArrayList<AuthorizationScenario[]>();
        for (AuthorizationScenario scenario : scenarios) {
            scenarioList.add(new AuthorizationScenario[]{scenario});
        }
        return scenarioList;
    }

    public AuthorizationScenarioInstanceBuilder init(AuthorizationScenario scenario) {
        AuthorizationScenarioInstanceBuilder builder = new AuthorizationScenarioInstanceBuilder();
        builder.scenario = scenario;
        builder.rule = this;
        return builder;
    }

    public static class AuthorizationScenarioInstanceBuilder {
        protected AuthorizationScenario scenario;
        protected AuthorizationTestRule rule;
        protected String userId;
        protected Map<String, String> resourceBindings = new HashMap<String, String>();

        public AuthorizationScenarioInstanceBuilder withUser(String userId) {
            this.userId = userId;
            return this;
        }

        public AuthorizationScenarioInstanceBuilder bindResource(String key, String value) {
            this.resourceBindings.put(key, value);
            return this;
        }

        public void start() {
            this.rule.start(this.scenario, this.userId, this.resourceBindings);
        }
    }
}

