/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.authorization.util;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.identity.Group;
import org.operaton.bpm.engine.identity.User;
import org.operaton.bpm.engine.test.ProcessEngineRule;

public class AuthorizationTestBaseRule
extends TestWatcher {
    protected ProcessEngineRule engineRule;
    protected List<User> users = new ArrayList<User>();
    protected List<Group> groups = new ArrayList<Group>();
    protected List<Authorization> authorizations = new ArrayList<Authorization>();

    public AuthorizationTestBaseRule(ProcessEngineRule engineRule) {
        this.engineRule = engineRule;
    }

    public void enableAuthorization(String userId) {
        this.engineRule.getProcessEngine().getProcessEngineConfiguration().setAuthorizationEnabled(true);
        if (userId != null) {
            this.engineRule.getIdentityService().setAuthenticatedUserId(userId);
        }
    }

    public void disableAuthorization() {
        this.engineRule.getProcessEngine().getProcessEngineConfiguration().setAuthorizationEnabled(false);
        this.engineRule.getIdentityService().clearAuthentication();
    }

    protected void finished(Description description) {
        this.engineRule.getIdentityService().clearAuthentication();
        this.deleteManagedAuthorizations();
        super.finished(description);
        ((ListAssert)Assertions.assertThat(this.users).as("Users have been created but not deleted", new Object[0])).isEmpty();
        ((ListAssert)Assertions.assertThat(this.groups).as("Groups have been created but not deleted", new Object[0])).isEmpty();
    }

    public void manageAuthorization(Authorization authorization) {
        this.authorizations.add(authorization);
    }

    protected Authorization createAuthorization(int type, Resource resource, String resourceId) {
        Authorization authorization = this.engineRule.getAuthorizationService().createNewAuthorization(type);
        authorization.setResource(resource);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    public void createGrantAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createAuthorization(1, resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.engineRule.getAuthorizationService().saveAuthorization(authorization);
        this.manageAuthorization(authorization);
    }

    public void createRevokeAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createAuthorization(2, resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.removePermission(permission);
        }
        this.engineRule.getAuthorizationService().saveAuthorization(authorization);
        this.manageAuthorization(authorization);
    }

    protected void deleteManagedAuthorizations() {
        for (Authorization authorization : this.authorizations) {
            this.engineRule.getAuthorizationService().deleteAuthorization(authorization.getId());
        }
    }

    public void createUserAndGroup(String userId, String groupId) {
        User user = this.engineRule.getIdentityService().newUser(userId);
        this.engineRule.getIdentityService().saveUser(user);
        this.users.add(user);
        Group group = this.engineRule.getIdentityService().newGroup(groupId);
        this.engineRule.getIdentityService().saveGroup(group);
        this.groups.add(group);
    }

    public void deleteUsersAndGroups() {
        for (User user : this.users) {
            this.engineRule.getIdentityService().deleteUser(user.getId());
        }
        this.users.clear();
        for (Group group : this.groups) {
            this.engineRule.getIdentityService().deleteGroup(group.getId());
        }
        this.groups.clear();
    }
}

