/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.authorization.util;

import java.util.Map;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Resource;

public class AuthorizationSpec {
    protected int type;
    protected Resource resource;
    protected String resourceId;
    protected String userId;
    protected Permission[] permissions;

    public static AuthorizationSpec auth(int type, Resource resource, String resourceId, String userId, Permission ... permissions) {
        AuthorizationSpec spec = new AuthorizationSpec();
        spec.type = type;
        spec.resource = resource;
        spec.resourceId = resourceId;
        spec.userId = userId;
        spec.permissions = permissions;
        return spec;
    }

    public static AuthorizationSpec global(Resource resource, String resourceId, String userId, Permission ... permissions) {
        return AuthorizationSpec.auth(0, resource, resourceId, userId, permissions);
    }

    public static AuthorizationSpec grant(Resource resource, String resourceId, String userId, Permission ... permissions) {
        return AuthorizationSpec.auth(1, resource, resourceId, userId, permissions);
    }

    public static AuthorizationSpec revoke(Resource resource, String resourceId, String userId, Permission ... permissions) {
        return AuthorizationSpec.auth(2, resource, resourceId, userId, permissions);
    }

    public Authorization instantiate(AuthorizationService authorizationService, Map<String, String> replacements) {
        Authorization authorization = authorizationService.createNewAuthorization(this.type);
        authorization.setResource(this.resource);
        if (replacements.containsKey(this.resourceId)) {
            authorization.setResourceId(replacements.get(this.resourceId));
        } else {
            authorization.setResourceId(this.resourceId);
        }
        authorization.setUserId(this.userId);
        authorization.setPermissions(this.permissions);
        return authorization;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Resource: ");
        sb.append(this.resource);
        sb.append(", Resource Id: ");
        sb.append(this.resourceId);
        sb.append(", Type: ");
        sb.append(this.type);
        sb.append(", User Id: ");
        sb.append(this.userId);
        sb.append(", Permissions: [");
        for (Permission permission : this.permissions) {
            sb.append(permission.getName());
            sb.append(", ");
        }
        sb.append("]]");
        return sb.toString();
    }
}

