/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test;

import java.io.FileNotFoundException;
import java.util.Date;
import junit.framework.TestCase;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.CaseService;
import org.operaton.bpm.engine.FilterService;
import org.operaton.bpm.engine.FormService;
import org.operaton.bpm.engine.HistoryService;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.RepositoryService;
import org.operaton.bpm.engine.RuntimeService;
import org.operaton.bpm.engine.TaskService;
import org.operaton.bpm.engine.impl.test.ProcessEngineAssert;
import org.operaton.bpm.engine.impl.test.TestHelper;
import org.operaton.bpm.engine.impl.util.ClockUtil;

public class ProcessEngineTestCase
extends TestCase {
    protected String configurationResource = "operaton.cfg.xml";
    protected String configurationResourceCompat = "activiti.cfg.xml";
    protected String deploymentId;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    @Deprecated(since="1.0")
    protected HistoryService historicDataService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected FilterService filterService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected boolean skipTest;

    public void assertProcessEnded(String processInstanceId) {
        ProcessEngineAssert.assertProcessEnded((ProcessEngine)this.processEngine, (String)processInstanceId);
    }

    protected void setUp() throws Exception {
        boolean hasRequiredHistoryLevel;
        super.setUp();
        if (this.processEngine == null) {
            this.initializeProcessEngine();
            this.initializeServices();
        }
        boolean bl = this.skipTest = !(hasRequiredHistoryLevel = TestHelper.annotationRequiredHistoryLevelCheck(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]));
        if (!this.skipTest) {
            this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]);
        }
    }

    protected void runTest() throws Throwable {
        if (!this.skipTest) {
            super.runTest();
        }
    }

    protected void initializeProcessEngine() {
        try {
            this.processEngine = TestHelper.getProcessEngine(this.getConfigurationResource());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)this.configurationResourceCompat).buildProcessEngine();
            }
            throw ex;
        }
    }

    protected void initializeServices() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historicDataService = this.processEngine.getHistoryService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
        this.filterService = this.processEngine.getFilterService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
    }

    protected void tearDown() throws Exception {
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
        ClockUtil.reset();
        super.tearDown();
    }

    public static void closeProcessEngines() {
        TestHelper.closeProcessEngines();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime((Date)currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }
}

