/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import org.apache.ibatis.logging.LogFactory;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.CaseService;
import org.operaton.bpm.engine.DecisionService;
import org.operaton.bpm.engine.ExternalTaskService;
import org.operaton.bpm.engine.FilterService;
import org.operaton.bpm.engine.FormService;
import org.operaton.bpm.engine.HistoryService;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.RepositoryService;
import org.operaton.bpm.engine.RuntimeService;
import org.operaton.bpm.engine.TaskService;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.test.PvmTestCase;
import org.operaton.bpm.engine.impl.test.TestHelper;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.repository.DeploymentBuilder;
import org.operaton.bpm.engine.runtime.ActivityInstance;
import org.operaton.bpm.engine.runtime.CaseInstance;
import org.operaton.bpm.engine.runtime.Job;
import org.operaton.bpm.engine.runtime.ProcessInstance;
import org.operaton.bpm.engine.test.util.JobExecutorWaitUtils;
import org.operaton.bpm.model.bpmn.BpmnModelInstance;
import org.slf4j.Logger;

public abstract class AbstractProcessEngineTestCase
extends PvmTestCase {
    private static final Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProcessEngine processEngine;
    protected String deploymentId;
    protected Set<String> deploymentIds = new HashSet<String>();
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected FilterService filterService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            boolean hasRequiredHistoryLevel = TestHelper.annotationRequiredHistoryLevelCheck(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]);
            boolean runsWithRequiredDatabase = TestHelper.annotationRequiredDatabaseCheck(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]);
            if (hasRequiredHistoryLevel && runsWithRequiredDatabase) {
                this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]);
                super.runBare();
            }
        }
        catch (AssertionFailedError e) {
            try {
                LOG.error("ASSERTION FAILED: {}", (Object)e.getMessage(), (Object)e);
                this.exception = e;
                throw e;
                catch (Throwable e2) {
                    LOG.error("EXCEPTION: {}", (Object)e2.getMessage(), (Object)e2);
                    this.exception = e2;
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.identityService.clearAuthentication();
                this.processEngineConfiguration.setTenantCheckEnabled(true);
                this.deleteDeployments();
                this.deleteHistoryCleanupJobs();
                TestHelper.assertAndEnsureCleanDbAndCache(this.processEngine, this.exception == null);
                TestHelper.resetIdGenerator(this.processEngineConfiguration);
                ClockUtil.reset();
                this.closeDownProcessEngine();
                this.clearServiceReferences();
                throw throwable;
            }
        }
        this.identityService.clearAuthentication();
        this.processEngineConfiguration.setTenantCheckEnabled(true);
        this.deleteDeployments();
        this.deleteHistoryCleanupJobs();
        TestHelper.assertAndEnsureCleanDbAndCache(this.processEngine, this.exception == null);
        TestHelper.resetIdGenerator(this.processEngineConfiguration);
        ClockUtil.reset();
        this.closeDownProcessEngine();
        this.clearServiceReferences();
    }

    protected void deleteHistoryCleanupJobs() {
        List jobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : jobs) {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
                commandContext.getJobManager().deleteJob((JobEntity)job);
                return null;
            });
        }
    }

    protected void deleteDeployments() {
        if (this.deploymentId != null) {
            this.deploymentIds.add(this.deploymentId);
        }
        for (String deployment : this.deploymentIds) {
            TestHelper.annotationDeploymentTearDown(this.processEngine, deployment, ((Object)((Object)this)).getClass(), this.getName());
        }
        this.deploymentId = null;
        this.deploymentIds.clear();
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
        this.filterService = this.processEngine.getFilterService();
        this.externalTaskService = this.processEngine.getExternalTaskService();
        this.decisionService = this.processEngine.getDecisionService();
    }

    protected void clearServiceReferences() {
        this.processEngineConfiguration = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.authorizationService = null;
        this.caseService = null;
        this.filterService = null;
        this.externalTaskService = null;
        this.decisionService = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
    }

    public void assertProcessNotEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new AssertionFailedError("Expected process instance '" + processInstanceId + "' to be still active but it was not in the db");
        }
    }

    public void assertCaseEnded(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance != null) {
            throw new AssertionFailedError("Expected finished case instance '" + caseInstanceId + "' but it was still in the db");
        }
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs((ProcessEngineConfiguration)this.processEngineConfiguration, maxMillisToWait, intervalMillis);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs((ProcessEngineConfiguration)this.processEngineConfiguration, maxMillisToWait);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobExecutorWaitUtils.waitForCondition(condition, maxMillisToWait, intervalMillis);
    }

    public void executeAvailableJobs() {
        this.executeAvailableJobs(0, Integer.MAX_VALUE, true, true);
    }

    public void executeAvailableJobs(int expectedExecutions) {
        this.executeAvailableJobs(0, expectedExecutions, false, true);
    }

    public void executeAvailableJobs(boolean recursive) {
        this.executeAvailableJobs(0, Integer.MAX_VALUE, true, recursive);
    }

    private void executeAvailableJobs(int jobsExecuted, int expectedExecutions, boolean ignoreLessExecutions, boolean recursive) {
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            AbstractProcessEngineTestCase.assertTrue((String)("executed less jobs than expected. expected <" + expectedExecutions + "> actual <" + jobsExecuted + ">"), (jobsExecuted == expectedExecutions || ignoreLessExecutions ? 1 : 0) != 0);
            return;
        }
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
                ++jobsExecuted;
            }
            catch (Exception exception) {}
        }
        AbstractProcessEngineTestCase.assertTrue((String)("executed more jobs than expected. expected <" + expectedExecutions + "> actual <" + jobsExecuted + ">"), (jobsExecuted <= expectedExecutions ? 1 : 0) != 0);
        if (recursive) {
            this.executeAvailableJobs(jobsExecuted, expectedExecutions, ignoreLessExecutions, recursive);
        }
    }

    @Deprecated
    protected List<ActivityInstance> getInstancesForActivitiyId(ActivityInstance activityInstance, String activityId) {
        return this.getInstancesForActivityId(activityInstance, activityId);
    }

    protected List<ActivityInstance> getInstancesForActivityId(ActivityInstance activityInstance, String activityId) {
        ArrayList<ActivityInstance> result = new ArrayList<ActivityInstance>();
        if (activityInstance.getActivityId().equals(activityId)) {
            result.add(activityInstance);
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            result.addAll(this.getInstancesForActivityId(childInstance, activityId));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsUser(String userId, List<String> groupIds, Runnable r) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            this.processEngineConfiguration.setAuthorizationEnabled(true);
            r.run();
        }
        finally {
            this.identityService.setAuthenticatedUserId(null);
            this.processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    protected String deployment(BpmnModelInstance ... bpmnModelInstances) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        return this.deployment(deploymentBuilder, bpmnModelInstances);
    }

    protected String deployment(String ... resources) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        return this.deployment(deploymentBuilder, resources);
    }

    protected String deploymentForTenant(String tenantId, BpmnModelInstance ... bpmnModelInstances) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().tenantId(tenantId);
        return this.deployment(deploymentBuilder, bpmnModelInstances);
    }

    protected String deploymentForTenant(String tenantId, String ... resources) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().tenantId(tenantId);
        return this.deployment(deploymentBuilder, resources);
    }

    protected String deploymentForTenant(String tenantId, String classpathResource, BpmnModelInstance modelInstance) {
        return this.deployment(this.repositoryService.createDeployment().tenantId(tenantId).addClasspathResource(classpathResource), modelInstance);
    }

    protected String deployment(DeploymentBuilder deploymentBuilder, BpmnModelInstance ... bpmnModelInstances) {
        for (int i = 0; i < bpmnModelInstances.length; ++i) {
            BpmnModelInstance bpmnModelInstance = bpmnModelInstances[i];
            deploymentBuilder.addModelInstance("testProcess-" + i + ".bpmn", bpmnModelInstance);
        }
        return this.deploymentWithBuilder(deploymentBuilder);
    }

    protected String deployment(DeploymentBuilder deploymentBuilder, String ... resources) {
        for (int i = 0; i < resources.length; ++i) {
            deploymentBuilder.addClasspathResource(resources[i]);
        }
        return this.deploymentWithBuilder(deploymentBuilder);
    }

    protected String deploymentWithBuilder(DeploymentBuilder builder) {
        this.deploymentId = builder.deploy().getId();
        this.deploymentIds.add(this.deploymentId);
        return this.deploymentId;
    }

    static {
        LogFactory.useSlf4jLogging();
    }
}

