/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.spring.components.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.spring.components.registry.ActivitiStateHandlerRegistration;
import org.operaton.commons.utils.StringUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ActivitiStateHandlerRegistry
extends ReceiveTaskActivityBehavior
implements BeanFactoryAware,
BeanNameAware,
ActivityBehavior,
InitializingBean {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private volatile ConcurrentHashMap<String, ActivitiStateHandlerRegistration> registrations = new ConcurrentHashMap();
    private ProcessEngine processEngine;

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void execute(ActivityExecution execution) throws Exception {
    }

    public void signal(ActivityExecution execution, String signalName, Object data) throws Exception {
        this.leave(execution);
    }

    protected String registrationKey(String processName, String stateName) {
        return (StringUtil.defaultString((String)processName) + ":" + StringUtil.defaultString((String)stateName)).toLowerCase();
    }

    public void registerActivitiStateHandler(ActivitiStateHandlerRegistration registration) {
        String regKey = this.registrationKey(registration.getProcessName(), registration.getStateName());
        this.registrations.put(regKey, registration);
    }

    public Collection<ActivitiStateHandlerRegistration> findRegistrationsForProcessAndState(String processName, String stateName) {
        String k;
        ArrayList<ActivitiStateHandlerRegistration> registrationCollection = new ArrayList<ActivitiStateHandlerRegistration>();
        String regKeyFull = this.registrationKey(processName, stateName);
        String regKeyWithJustState = this.registrationKey(null, stateName);
        for (Map.Entry<String, ActivitiStateHandlerRegistration> reg : this.registrations.entrySet()) {
            k = reg.getKey();
            if (!k.contains(regKeyFull)) continue;
            registrationCollection.add(reg.getValue());
        }
        if (registrationCollection.isEmpty()) {
            for (Map.Entry<String, ActivitiStateHandlerRegistration> reg : this.registrations.entrySet()) {
                k = reg.getKey();
                if (!k.contains(regKeyWithJustState)) continue;
                registrationCollection.add(reg.getValue());
            }
        }
        return registrationCollection;
    }

    public ActivitiStateHandlerRegistration findRegistrationForProcessAndState(String processName, String stateName) {
        String kName;
        ActivitiStateHandlerRegistration r = null;
        String key = this.registrationKey(processName, stateName);
        Collection<ActivitiStateHandlerRegistration> rs = this.findRegistrationsForProcessAndState(processName, stateName);
        for (ActivitiStateHandlerRegistration sr : rs) {
            kName = this.registrationKey(sr.getProcessName(), sr.getStateName());
            if (!key.equalsIgnoreCase(kName)) continue;
            r = sr;
            break;
        }
        for (ActivitiStateHandlerRegistration sr : rs) {
            kName = this.registrationKey(null, sr.getStateName());
            if (!key.equalsIgnoreCase(kName)) continue;
            r = sr;
            break;
        }
        if (r == null && !rs.isEmpty()) {
            r = rs.iterator().next();
        }
        return r;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    public void setBeanName(String name) {
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.processEngine, (String)"the 'processEngine' can't be null");
        this.logger.info(() -> "this bean contains a processEngine reference. " + String.valueOf(this.processEngine));
        this.logger.info(() -> "starting " + ((Object)((Object)this)).getClass().getName());
    }
}

