/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.spin.plugin.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.operaton.spin.DataFormats;
import org.operaton.spin.json.SpinJsonNode;
import org.operaton.spin.plugin.impl.JsonValueSerializer;
import org.operaton.spin.plugin.impl.SpinObjectValueSerializer;
import org.operaton.spin.plugin.impl.XmlValueSerializer;
import org.operaton.spin.spi.DataFormat;
import org.operaton.spin.xml.SpinXmlElement;

public final class SpinVariableSerializers {
    private SpinVariableSerializers() {
    }

    public static List<TypedValueSerializer<?>> createObjectValueSerializers(DataFormats dataFormats) {
        ArrayList serializers = new ArrayList();
        Set availableDataFormats = dataFormats.getAllAvailableDataFormats();
        for (DataFormat dataFormat : availableDataFormats) {
            serializers.add((TypedValueSerializer<?>)new SpinObjectValueSerializer("spin://" + dataFormat.getName(), dataFormat));
        }
        return serializers;
    }

    public static List<TypedValueSerializer<?>> createSpinValueSerializers(DataFormats dataFormats) {
        ArrayList serializers = new ArrayList();
        if (dataFormats.getDataFormatByName("application/json") != null) {
            DataFormat jsonDataFormat = dataFormats.getDataFormatByName("application/json");
            serializers.add((TypedValueSerializer<?>)new JsonValueSerializer((DataFormat<SpinJsonNode>)jsonDataFormat));
        }
        if (dataFormats.getDataFormatByName("application/xml") != null) {
            DataFormat xmlDataFormat = dataFormats.getDataFormatByName("application/xml");
            serializers.add((TypedValueSerializer<?>)new XmlValueSerializer((DataFormat<SpinXmlElement>)xmlDataFormat));
        }
        return serializers;
    }
}

