/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.junit5;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.operaton.bpm.engine.test.junit5.WatchLogger;
import org.slf4j.LoggerFactory;

public class ProcessEngineLoggingExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public static final String LOGGER_NOT_FOUND_ERROR = "no logger found with name ";
    public static final String NOT_WATCHING_ERROR = "not watching any logger with name: ";
    private static final String APPENDER_NAME = "defaultAppender";
    private final Map<String, Logger> globallyWatched = new HashMap<String, Logger>();
    private Level globalLevel = Level.DEBUG;
    private final Map<String, Logger> allWatched = new HashMap<String, Logger>();

    public ProcessEngineLoggingExtension watch(String ... loggerName) {
        for (String logger : loggerName) {
            this.watch(logger, (Level)null);
        }
        return this;
    }

    public ProcessEngineLoggingExtension watch(String loggerName, Level level) {
        Logger logger = this.getLogger(loggerName);
        logger.setLevel(level);
        this.globallyWatched.put(logger.getName(), logger);
        return this;
    }

    public ProcessEngineLoggingExtension level(Level level) {
        this.globalLevel = level;
        return this;
    }

    private Logger getLogger(String loggerName) {
        Logger logger;
        try {
            logger = (Logger)LoggerFactory.getLogger((String)loggerName);
            if (logger.getLevel() == null || this.globalLevel.isGreaterOrEqual(logger.getLevel())) {
                logger.setLevel(this.globalLevel);
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(LOGGER_NOT_FOUND_ERROR + loggerName);
        }
        return logger;
    }

    public List<ILoggingEvent> getLog(String loggerName) {
        Logger logger = this.allWatched.get(loggerName);
        if (logger == null) {
            throw new RuntimeException(NOT_WATCHING_ERROR + loggerName);
        }
        return ((ListAppender)logger.getAppender((String)APPENDER_NAME)).list;
    }

    public List<ILoggingEvent> getLog() {
        ArrayList<ILoggingEvent> allLogs = new ArrayList<ILoggingEvent>();
        for (String loggerName : this.allWatched.keySet()) {
            allLogs.addAll(this.getLog(loggerName));
        }
        allLogs.sort((event1, event2) -> Long.valueOf(event1.getTimeStamp() - event2.getTimeStamp()).intValue());
        return allLogs;
    }

    public List<ILoggingEvent> getFilteredLog(String subString) {
        List<ILoggingEvent> log = this.getLog();
        return this.filterLog(log, subString);
    }

    public List<ILoggingEvent> getFilteredLog(String loggerName, String subString) {
        List<ILoggingEvent> log = this.getLog(loggerName);
        return this.filterLog(log, subString);
    }

    public void beforeTestExecution(ExtensionContext context) {
        HashMap<String, Logger> toWatch = new HashMap<String, Logger>(this.globallyWatched);
        WatchLogger watchLoggerAnnotation = context.getRequiredTestMethod().getAnnotation(WatchLogger.class);
        if (watchLoggerAnnotation != null) {
            Level level = Level.toLevel((String)watchLoggerAnnotation.level());
            if (level == null) {
                level = this.globalLevel;
            }
            for (String loggerName : watchLoggerAnnotation.loggerNames()) {
                Logger logger = this.getLogger(loggerName);
                logger.setLevel(level);
                toWatch.put(loggerName, logger);
            }
        }
        this.watchLoggers(toWatch);
    }

    public void afterTestExecution(ExtensionContext context) {
        for (Logger logger : this.allWatched.values()) {
            logger.detachAppender(APPENDER_NAME);
            logger.setLevel(null);
        }
        this.allWatched.clear();
    }

    private void watchLoggers(Map<String, Logger> loggers) {
        for (Map.Entry<String, Logger> loggerEntry : loggers.entrySet()) {
            ListAppender listAppender = new ListAppender();
            listAppender.setName(APPENDER_NAME);
            listAppender.start();
            Logger logger = loggerEntry.getValue();
            if (logger.getLevel() == null) {
                logger.setLevel(this.globalLevel);
            }
            logger.addAppender((Appender)listAppender);
            this.allWatched.put(loggerEntry.getKey(), logger);
        }
    }

    private List<ILoggingEvent> filterLog(List<ILoggingEvent> log, String subString) {
        ArrayList<ILoggingEvent> filteredLog = new ArrayList<ILoggingEvent>();
        for (ILoggingEvent logEntry : log) {
            if (!logEntry.getFormattedMessage().contains(subString)) continue;
            filteredLog.add(logEntry);
        }
        return filteredLog;
    }
}

