/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.junit5;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

public class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return context.getTestClass().map(cls -> cls.isAnnotationPresent(Parameterized.class)).orElse(false);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Object parametersResult;
        Class testClass;
        Class c = testClass = context.getRequiredTestClass();
        Method parametersMethod = null;
        do {
            Optional<Method> first;
            if (!(first = Arrays.stream(c.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Parameters.class) && Modifier.isStatic(m.getModifiers())).findFirst()).isPresent()) continue;
            parametersMethod = first.get();
            break;
        } while ((c = c.getSuperclass()) != null);
        if (parametersMethod == null) {
            throw new ExtensionConfigurationException("No static @Parameters method found in " + testClass.getName());
        }
        Parameters parametersAnnotation = parametersMethod.getAnnotation(Parameters.class);
        String displayNameFormat = parametersAnnotation.name();
        try {
            parametersMethod.setAccessible(true);
            parametersResult = parametersMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException("Failed to invoke @Parameters method", (Throwable)e);
        }
        if (!(parametersResult instanceof Collection)) {
            throw new ExtensionConfigurationException("@Parameters method must return a Collection<Object>");
        }
        Collection parameterSets = (Collection)parametersResult;
        return parameterSets.stream().map(params -> new ParameterizedTestInvocationContext(params, displayNameFormat));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "";
    }

    private static class ParameterizedTestInvocationContext
    implements TestTemplateInvocationContext {
        private final Object[] parameters;
        private final String displayNameFormat;

        ParameterizedTestInvocationContext(Object parameters, String displayNameFormat) {
            this.displayNameFormat = displayNameFormat;
            if (parameters instanceof Object[]) {
                Object[] parametersArray = (Object[])parameters;
                this.parameters = parametersArray;
            } else {
                this.parameters = new Object[]{parameters};
            }
        }

        public String getDisplayName(int invocationIndex) {
            if ("".equals(this.displayNameFormat)) {
                return "Parameters: " + Arrays.toString(this.parameters);
            }
            return MessageFormat.format(this.displayNameFormat, this.parameters);
        }

        public List<Extension> getAdditionalExtensions() {
            return Arrays.asList(new ParameterResolver(){

                public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                    return true;
                }

                public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                    int index = parameterContext.getIndex();
                    if (index >= parameters.length) {
                        throw new ParameterResolutionException("Not enough parameters provided; index " + index + " out of " + parameters.length);
                    }
                    return parameters[index];
                }
            }, (factoryContext, extensionContext) -> {
                try {
                    Class testClass = extensionContext.getRequiredTestClass();
                    Constructor<?> constructor = testClass.getDeclaredConstructors()[0];
                    constructor.setAccessible(true);
                    return constructor.newInstance(this.parameters);
                }
                catch (Exception e) {
                    throw new TestInstantiationException("Could not create test instance", (Throwable)e);
                }
            }, new TestInstancePostProcessor(){

                public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
                    Class<?> c = testInstance.getClass();
                    do {
                        this.addFields(testInstance, c);
                    } while ((c = c.getSuperclass()) != null);
                }

                private void addFields(Object testInstance, Class<?> c) throws IllegalArgumentException, IllegalAccessException {
                    for (Field field : c.getDeclaredFields()) {
                        Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
                        if (parameterAnnotation == null) continue;
                        int index = parameterAnnotation.value();
                        if (index < 0 || index >= parameters.length) {
                            throw new ExtensionConfigurationException("Index " + index + " is out of bounds for the provided parameters array.");
                        }
                        field.setAccessible(true);
                        field.set(testInstance, parameters[index]);
                    }
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @ExtendWith(value={ParameterizedTestExtension.class})
    public static @interface Parameterized {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public int value() default 0;
    }
}

