/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.juel.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;

public class EndpointTransformer
implements FeelToJuelTransformer {
    public static final Pattern DATE_AND_TIME_PATTERN = Pattern.compile("^date and time\\((.+)\\)$");

    @Override
    public boolean canTransform(String feelExpression) {
        return true;
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        Matcher matcher = DATE_AND_TIME_PATTERN.matcher(feelExpression);
        if (matcher.matches()) {
            return "dateAndTime(" + matcher.group(1) + ")";
        }
        return feelExpression;
    }
}

