/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.type;

import java.util.HashMap;
import java.util.Map;
import org.operaton.bpm.dmn.engine.impl.DmnEngineLogger;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformerRegistry;
import org.operaton.bpm.dmn.engine.impl.type.BooleanDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.type.DateDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.type.DoubleDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.type.IdentityDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.type.IntegerDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.type.LongDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.type.StringDataTypeTransformer;

public class DefaultDataTypeTransformerRegistry
implements DmnDataTypeTransformerRegistry {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected static final Map<String, DmnDataTypeTransformer> transformers = DefaultDataTypeTransformerRegistry.getDefaultTransformers();

    protected static Map<String, DmnDataTypeTransformer> getDefaultTransformers() {
        HashMap<String, DmnDataTypeTransformer> transformers = new HashMap<String, DmnDataTypeTransformer>();
        transformers.put("string", new StringDataTypeTransformer());
        transformers.put("boolean", new BooleanDataTypeTransformer());
        transformers.put("integer", new IntegerDataTypeTransformer());
        transformers.put("long", new LongDataTypeTransformer());
        transformers.put("double", new DoubleDataTypeTransformer());
        transformers.put("date", new DateDataTypeTransformer());
        return transformers;
    }

    @Override
    public void addTransformer(String typeName, DmnDataTypeTransformer transformer) {
        transformers.put(typeName, transformer);
    }

    @Override
    public DmnDataTypeTransformer getTransformer(String typeName) {
        if (typeName != null && transformers.containsKey(typeName.toLowerCase())) {
            return transformers.get(typeName.toLowerCase());
        }
        LOG.unsupportedTypeDefinitionForClause(typeName);
        return new IdentityDataTypeTransformer();
    }
}

