/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.transform;

import java.io.File;
import org.operaton.bpm.dmn.engine.DmnDecision;
import org.operaton.bpm.dmn.engine.DmnDecisionRequirementsGraph;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableInputImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableOutputImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableRuleImpl;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.dmn.engine.impl.transform.DmnTransformException;
import org.operaton.bpm.model.dmn.BuiltinAggregator;
import org.operaton.bpm.model.dmn.HitPolicy;
import org.operaton.bpm.model.dmn.instance.Decision;
import org.operaton.bpm.model.dmn.instance.Expression;

public class DmnTransformLogger
extends DmnLogger {
    public void decisionTypeNotSupported(Expression expression, Decision decision) {
        this.logInfo("001", "The expression type '{}' of the decision '{}' is not supported. The decision will be ignored.", new Object[]{expression.getClass().getSimpleName(), decision.getName()});
    }

    public DmnTransformException unableToTransformDecisionsFromFile(File file, Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("002", "Unable to transform decisions from file '{}'.", new Object[]{file.getAbsolutePath()}), cause);
    }

    public DmnTransformException unableToTransformDecisionsFromInputStream(Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("003", "Unable to transform decisions from input stream.", new Object[0]), cause);
    }

    public DmnTransformException errorWhileTransformingDecisions(Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("004", "Error while transforming decisions: " + cause.getMessage(), new Object[0]), cause);
    }

    public DmnTransformException differentNumberOfInputsAndInputEntries(int inputsSize, int inputEntriesSize, DmnDecisionTableRuleImpl rule) {
        return new DmnTransformException(this.exceptionMessage("005", "The number of inputs '{}' and input entries differ '{}' for rule '{}'.", new Object[]{inputsSize, inputEntriesSize, rule}));
    }

    public DmnTransformException differentNumberOfOutputsAndOutputEntries(int outputsSize, int outputEntriesSize, DmnDecisionTableRuleImpl rule) {
        return new DmnTransformException(this.exceptionMessage("006", "The number of outputs '{}' and output entries differ '{}' for rule '{}'.", new Object[]{outputsSize, outputEntriesSize, rule}));
    }

    public DmnTransformException hitPolicyNotSupported(DmnDecisionTableImpl decisionTable, HitPolicy hitPolicy, BuiltinAggregator aggregation) {
        if (aggregation == null) {
            return new DmnTransformException(this.exceptionMessage("007", "The hit policy '{}' of decision table '{}' is not supported.", new Object[]{hitPolicy, decisionTable}));
        }
        return new DmnTransformException(this.exceptionMessage("007", "The hit policy '{}' with aggregation '{}' of decision table '{}' is not supported.", new Object[]{hitPolicy, aggregation, decisionTable}));
    }

    public DmnTransformException compoundOutputsShouldHaveAnOutputName(DmnDecisionTableImpl dmnDecisionTable, DmnDecisionTableOutputImpl dmnOutput) {
        return new DmnTransformException(this.exceptionMessage("008", "The decision table '{}' has a compound output but output '{}' does not have an output name.", new Object[]{dmnDecisionTable, dmnOutput}));
    }

    public DmnTransformException compoundOutputWithDuplicateName(DmnDecisionTableImpl dmnDecisionTable, DmnDecisionTableOutputImpl dmnOutput) {
        return new DmnTransformException(this.exceptionMessage("009", "The decision table '{}' has a compound output but name of output '{}' is duplicate.", new Object[]{dmnDecisionTable, dmnOutput}));
    }

    public DmnTransformException decisionIdIsMissing(DmnDecision dmnDecision) {
        return new DmnTransformException(this.exceptionMessage("010", "The decision '{}' must have an 'id' attribute set.", new Object[]{dmnDecision}));
    }

    public DmnTransformException decisionTableInputIdIsMissing(DmnDecision dmnDecision, DmnDecisionTableInputImpl dmnDecisionTableInput) {
        return new DmnTransformException(this.exceptionMessage("011", "The decision table input '{}' of decision '{}' must have a 'id' attribute set.", new Object[]{dmnDecisionTableInput, dmnDecision}));
    }

    public DmnTransformException decisionTableOutputIdIsMissing(DmnDecision dmnDecision, DmnDecisionTableOutputImpl dmnDecisionTableOutput) {
        return new DmnTransformException(this.exceptionMessage("012", "The decision table output '{}' of decision '{}' must have a 'id' attribute set.", new Object[]{dmnDecisionTableOutput, dmnDecision}));
    }

    public DmnTransformException decisionTableRuleIdIsMissing(DmnDecision dmnDecision, DmnDecisionTableRuleImpl dmnDecisionTableRule) {
        return new DmnTransformException(this.exceptionMessage("013", "The decision table rule '{}' of decision '{}' must have a 'id' attribute set.", new Object[]{dmnDecisionTableRule, dmnDecision}));
    }

    public void decisionWithoutExpression(Decision decision) {
        this.logInfo("014", "The decision '{}' has no expression and will be ignored.", new Object[]{decision.getName()});
    }

    public DmnTransformException requiredDecisionLoopDetected(String decisionId) {
        return new DmnTransformException(this.exceptionMessage("015", "The decision '{}' has a loop.", new Object[]{decisionId}));
    }

    public DmnTransformException errorWhileTransformingDefinitions(Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("016", "Error while transforming decision requirements graph: " + cause.getMessage(), new Object[0]), cause);
    }

    public DmnTransformException drdIdIsMissing(DmnDecisionRequirementsGraph drd) {
        return new DmnTransformException(this.exceptionMessage("017", "The decision requirements graph '{}' must have an 'id' attribute set.", new Object[]{drd}));
    }

    public DmnTransformException decisionVariableIsMissing(String decisionId) {
        return new DmnTransformException(this.exceptionMessage("018", "The decision '{}' must have an 'variable' element if it contains a literal expression.", new Object[]{decisionId}));
    }
}

