/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.transform;

import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import org.operaton.bpm.dmn.engine.impl.transform.DmnTransformLogger;
import org.operaton.bpm.model.dmn.BuiltinAggregator;
import org.operaton.bpm.model.dmn.HitPolicy;
import org.operaton.bpm.model.dmn.instance.DecisionTable;

public class DmnDecisionTableTransformHandler
implements DmnElementTransformHandler<DecisionTable, DmnDecisionTableImpl> {
    protected static final DmnTransformLogger LOG = DmnLogger.TRANSFORM_LOGGER;

    @Override
    public DmnDecisionTableImpl handleElement(DmnElementTransformContext context, DecisionTable decisionTable) {
        return this.createFromDecisionTable(context, decisionTable);
    }

    protected DmnDecisionTableImpl createFromDecisionTable(DmnElementTransformContext context, DecisionTable decisionTable) {
        DmnDecisionTableImpl dmnDecisionTable = this.createDmnElement(context, decisionTable);
        dmnDecisionTable.setHitPolicyHandler(this.getHitPolicyHandler(context, decisionTable, dmnDecisionTable));
        return dmnDecisionTable;
    }

    protected DmnDecisionTableImpl createDmnElement(DmnElementTransformContext context, DecisionTable decisionTable) {
        return new DmnDecisionTableImpl();
    }

    protected DmnHitPolicyHandler getHitPolicyHandler(DmnElementTransformContext context, DecisionTable decisionTable, DmnDecisionTableImpl dmnDecisionTable) {
        HitPolicy hitPolicy = decisionTable.getHitPolicy();
        if (hitPolicy == null) {
            hitPolicy = HitPolicy.UNIQUE;
        }
        BuiltinAggregator aggregation = decisionTable.getAggregation();
        DmnHitPolicyHandler hitPolicyHandler = context.getHitPolicyHandlerRegistry().getHandler(hitPolicy, aggregation);
        if (hitPolicyHandler != null) {
            return hitPolicyHandler;
        }
        throw LOG.hitPolicyNotSupported(dmnDecisionTable, hitPolicy, aggregation);
    }
}

