/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.operaton.bpm.dmn.engine.DmnDecisionResult;
import org.operaton.bpm.dmn.engine.DmnDecisionResultEntries;
import org.operaton.bpm.dmn.engine.DmnDecisionRuleResult;
import org.operaton.bpm.dmn.engine.DmnDecisionTableResult;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionRuleResultImpl;
import org.operaton.bpm.dmn.engine.impl.DmnEngineLogger;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class DmnDecisionTableResultImpl
implements DmnDecisionTableResult {
    private static final long serialVersionUID = 1L;
    public static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected final List<DmnDecisionRuleResult> ruleResults;

    public DmnDecisionTableResultImpl(List<DmnDecisionRuleResult> ruleResults) {
        this.ruleResults = ruleResults;
    }

    @Override
    public DmnDecisionRuleResult getFirstResult() {
        if (!this.isEmpty()) {
            return this.get(0);
        }
        return null;
    }

    @Override
    public DmnDecisionRuleResult getSingleResult() {
        if (this.size() == 1) {
            return this.get(0);
        }
        if (this.isEmpty()) {
            return null;
        }
        throw LOG.decisionResultHasMoreThanOneOutput(this);
    }

    @Override
    public <T> List<T> collectEntries(String outputName) {
        ArrayList outputValues = new ArrayList();
        for (DmnDecisionRuleResult ruleResult : this.ruleResults) {
            if (!ruleResult.containsKey(outputName)) continue;
            Object value = ruleResult.get(outputName);
            outputValues.add(value);
        }
        return outputValues;
    }

    @Override
    public List<Map<String, Object>> getResultList() {
        ArrayList<Map<String, Object>> entryMapList = new ArrayList<Map<String, Object>>();
        for (DmnDecisionRuleResult ruleResult : this.ruleResults) {
            Map<String, Object> entryMap = ruleResult.getEntryMap();
            entryMapList.add(entryMap);
        }
        return entryMapList;
    }

    @Override
    public <T> T getSingleEntry() {
        DmnDecisionRuleResult result = this.getSingleResult();
        if (result != null) {
            return result.getSingleEntry();
        }
        return null;
    }

    @Override
    public <T extends TypedValue> T getSingleEntryTyped() {
        DmnDecisionRuleResult result = this.getSingleResult();
        if (result != null) {
            return result.getSingleEntryTyped();
        }
        return null;
    }

    @Override
    public Iterator<DmnDecisionRuleResult> iterator() {
        return this.asUnmodifiableList().iterator();
    }

    @Override
    public int size() {
        return this.ruleResults.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ruleResults.isEmpty();
    }

    @Override
    public DmnDecisionRuleResult get(int index) {
        return this.ruleResults.get(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.ruleResults.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.ruleResults.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ruleResults.toArray(a);
    }

    @Override
    public boolean add(DmnDecisionRuleResult e) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ruleResults.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends DmnDecisionRuleResult> c) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean addAll(int index, Collection<? extends DmnDecisionRuleResult> c) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public DmnDecisionRuleResult set(int index, DmnDecisionRuleResult element) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public void add(int index, DmnDecisionRuleResult element) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public DmnDecisionRuleResult remove(int index) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public int indexOf(Object o) {
        return this.ruleResults.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.ruleResults.lastIndexOf(o);
    }

    @Override
    public ListIterator<DmnDecisionRuleResult> listIterator() {
        return this.asUnmodifiableList().listIterator();
    }

    @Override
    public ListIterator<DmnDecisionRuleResult> listIterator(int index) {
        return this.asUnmodifiableList().listIterator(index);
    }

    @Override
    public List<DmnDecisionRuleResult> subList(int fromIndex, int toIndex) {
        return this.asUnmodifiableList().subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.ruleResults.toString();
    }

    protected List<DmnDecisionRuleResult> asUnmodifiableList() {
        return Collections.unmodifiableList(this.ruleResults);
    }

    public static DmnDecisionTableResultImpl wrap(DmnDecisionResult decisionResult) {
        ArrayList<DmnDecisionRuleResult> ruleResults = new ArrayList<DmnDecisionRuleResult>();
        for (DmnDecisionResultEntries result : decisionResult) {
            DmnDecisionRuleResultImpl ruleResult = new DmnDecisionRuleResultImpl();
            ruleResult.putAllValues(result.getEntryMapTyped());
            ruleResults.add(ruleResult);
        }
        return new DmnDecisionTableResultImpl(ruleResults);
    }
}

