/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.operaton.bpm.dmn.engine.DmnEngine;
import org.operaton.bpm.dmn.engine.DmnEngineConfiguration;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionEvaluationListener;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.operaton.bpm.dmn.engine.impl.DefaultDmnEngine;
import org.operaton.bpm.dmn.engine.impl.el.DefaultScriptEngineResolver;
import org.operaton.bpm.dmn.engine.impl.el.JuelElProvider;
import org.operaton.bpm.dmn.engine.impl.metrics.DefaultEngineMetricCollector;
import org.operaton.bpm.dmn.engine.impl.metrics.DmnEngineMetricCollectorWrapper;
import org.operaton.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.operaton.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.operaton.bpm.dmn.engine.impl.transform.DefaultDmnTransformer;
import org.operaton.bpm.dmn.engine.spi.DmnEngineMetricCollector;
import org.operaton.bpm.dmn.feel.impl.FeelEngine;
import org.operaton.bpm.dmn.feel.impl.FeelEngineFactory;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineFactoryImpl;
import org.operaton.bpm.dmn.feel.impl.scala.ScalaFeelEngineFactory;
import org.operaton.bpm.dmn.feel.impl.scala.function.FeelCustomFunctionProvider;

public class DefaultDmnEngineConfiguration
extends DmnEngineConfiguration {
    public static final String FEEL_EXPRESSION_LANGUAGE = "http://www.omg.org/spec/FEEL/20140401";
    public static final String FEEL_EXPRESSION_LANGUAGE_ALTERNATIVE = "feel";
    public static final String FEEL_EXPRESSION_LANGUAGE_DMN12 = "http://www.omg.org/spec/DMN/20180521/FEEL/";
    public static final String FEEL_EXPRESSION_LANGUAGE_DMN13 = "https://www.omg.org/spec/DMN/20191111/FEEL/";
    public static final String FEEL_EXPRESSION_LANGUAGE_DMN14 = "https://www.omg.org/spec/DMN/20211108/FEEL/";
    public static final String FEEL_EXPRESSION_LANGUAGE_DMN15 = "https://www.omg.org/spec/DMN/20230324/FEEL/";
    public static final String JUEL_EXPRESSION_LANGUAGE = "juel";
    protected DmnEngineMetricCollector engineMetricCollector;
    protected List<DmnDecisionTableEvaluationListener> customPreDecisionTableEvaluationListeners = new ArrayList<DmnDecisionTableEvaluationListener>();
    protected List<DmnDecisionTableEvaluationListener> customPostDecisionTableEvaluationListeners = new ArrayList<DmnDecisionTableEvaluationListener>();
    protected List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners;
    protected List<DmnDecisionEvaluationListener> decisionEvaluationListeners;
    protected List<DmnDecisionEvaluationListener> customPreDecisionEvaluationListeners = new ArrayList<DmnDecisionEvaluationListener>();
    protected List<DmnDecisionEvaluationListener> customPostDecisionEvaluationListeners = new ArrayList<DmnDecisionEvaluationListener>();
    protected DmnScriptEngineResolver scriptEngineResolver;
    protected ElProvider elProvider;
    protected FeelEngineFactory feelEngineFactory;
    protected FeelEngine feelEngine;
    protected List<FeelCustomFunctionProvider> feelCustomFunctionProviders;
    protected boolean enableFeelLegacyBehavior;
    protected String defaultInputExpressionExpressionLanguage;
    protected String defaultInputEntryExpressionLanguage;
    protected String defaultOutputEntryExpressionLanguage;
    protected String defaultLiteralExpressionLanguage;
    protected DmnTransformer transformer = new DefaultDmnTransformer();
    protected boolean returnBlankTableOutputAsNull;

    @Override
    public DmnEngine buildEngine() {
        this.init();
        return new DefaultDmnEngine(this);
    }

    public void init() {
        this.initMetricCollector();
        this.initDecisionTableEvaluationListener();
        this.initDecisionEvaluationListener();
        this.initScriptEngineResolver();
        this.initElDefaults();
        this.initElProvider();
        this.initFeelEngine();
    }

    public void initElDefaults() {
        if (this.enableFeelLegacyBehavior) {
            this.initFeelLegacyBehavior();
        } else {
            this.initFeelDefaultBehavior();
        }
    }

    private void initFeelDefaultBehavior() {
        if (this.defaultInputExpressionExpressionLanguage == null) {
            this.defaultInputExpressionExpressionLanguage(FEEL_EXPRESSION_LANGUAGE);
        }
        if (this.defaultInputEntryExpressionLanguage == null) {
            this.defaultInputEntryExpressionLanguage(FEEL_EXPRESSION_LANGUAGE);
        }
        if (this.defaultOutputEntryExpressionLanguage == null) {
            this.defaultOutputEntryExpressionLanguage(FEEL_EXPRESSION_LANGUAGE);
        }
        if (this.defaultLiteralExpressionLanguage == null) {
            this.defaultLiteralExpressionLanguage(FEEL_EXPRESSION_LANGUAGE);
        }
    }

    private void initFeelLegacyBehavior() {
        if (this.defaultInputExpressionExpressionLanguage == null) {
            this.defaultInputExpressionExpressionLanguage(JUEL_EXPRESSION_LANGUAGE);
        }
        if (this.defaultInputEntryExpressionLanguage == null) {
            this.defaultInputEntryExpressionLanguage(FEEL_EXPRESSION_LANGUAGE);
        }
        if (this.defaultOutputEntryExpressionLanguage == null) {
            this.defaultOutputEntryExpressionLanguage(JUEL_EXPRESSION_LANGUAGE);
        }
        if (this.defaultLiteralExpressionLanguage == null) {
            this.defaultLiteralExpressionLanguage(JUEL_EXPRESSION_LANGUAGE);
        }
    }

    protected void initMetricCollector() {
        if (this.engineMetricCollector == null) {
            this.engineMetricCollector = new DefaultEngineMetricCollector();
        }
    }

    protected void initDecisionTableEvaluationListener() {
        ArrayList<DmnDecisionTableEvaluationListener> listeners = new ArrayList<DmnDecisionTableEvaluationListener>();
        if (this.customPreDecisionTableEvaluationListeners != null && !this.customPreDecisionTableEvaluationListeners.isEmpty()) {
            listeners.addAll(this.customPreDecisionTableEvaluationListeners);
        }
        if (this.customPostDecisionTableEvaluationListeners != null && !this.customPostDecisionTableEvaluationListeners.isEmpty()) {
            listeners.addAll(this.customPostDecisionTableEvaluationListeners);
        }
        this.decisionTableEvaluationListeners = listeners;
    }

    protected void initDecisionEvaluationListener() {
        ArrayList<DmnDecisionEvaluationListener> listeners = new ArrayList<DmnDecisionEvaluationListener>();
        if (this.customPreDecisionEvaluationListeners != null && !this.customPreDecisionEvaluationListeners.isEmpty()) {
            listeners.addAll(this.customPreDecisionEvaluationListeners);
        }
        listeners.addAll(this.getDefaultDmnDecisionEvaluationListeners());
        if (this.customPostDecisionEvaluationListeners != null && !this.customPostDecisionEvaluationListeners.isEmpty()) {
            listeners.addAll(this.customPostDecisionEvaluationListeners);
        }
        this.decisionEvaluationListeners = listeners;
    }

    protected Collection<DmnDecisionEvaluationListener> getDefaultDmnDecisionEvaluationListeners() {
        ArrayList<DmnDecisionEvaluationListener> defaultListeners = new ArrayList<DmnDecisionEvaluationListener>();
        DmnEngineMetricCollector dmnEngineMetricCollector = this.engineMetricCollector;
        if (dmnEngineMetricCollector instanceof DmnDecisionEvaluationListener) {
            DmnDecisionEvaluationListener listener = (DmnDecisionEvaluationListener)((Object)dmnEngineMetricCollector);
            defaultListeners.add(listener);
        } else {
            defaultListeners.add(new DmnEngineMetricCollectorWrapper(this.engineMetricCollector));
        }
        return defaultListeners;
    }

    protected void initElProvider() {
        if (this.elProvider == null) {
            this.elProvider = new JuelElProvider();
        }
    }

    protected void initScriptEngineResolver() {
        if (this.scriptEngineResolver == null) {
            this.scriptEngineResolver = new DefaultScriptEngineResolver();
        }
    }

    protected void initFeelEngine() {
        if (this.feelEngineFactory == null) {
            this.feelEngineFactory = !this.enableFeelLegacyBehavior ? new ScalaFeelEngineFactory(this.feelCustomFunctionProviders) : new FeelEngineFactoryImpl();
        }
        if (this.feelEngine == null) {
            this.feelEngine = this.feelEngineFactory.createInstance();
        }
    }

    @Override
    public DmnEngineMetricCollector getEngineMetricCollector() {
        return this.engineMetricCollector;
    }

    @Override
    public void setEngineMetricCollector(DmnEngineMetricCollector engineMetricCollector) {
        this.engineMetricCollector = engineMetricCollector;
    }

    @Override
    public DefaultDmnEngineConfiguration engineMetricCollector(DmnEngineMetricCollector engineMetricCollector) {
        this.setEngineMetricCollector(engineMetricCollector);
        return this;
    }

    @Override
    public List<DmnDecisionTableEvaluationListener> getCustomPreDecisionTableEvaluationListeners() {
        return this.customPreDecisionTableEvaluationListeners;
    }

    @Override
    public void setCustomPreDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.customPreDecisionTableEvaluationListeners = decisionTableEvaluationListeners;
    }

    @Override
    public DefaultDmnEngineConfiguration customPreDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.setCustomPreDecisionTableEvaluationListeners(decisionTableEvaluationListeners);
        return this;
    }

    @Override
    public List<DmnDecisionTableEvaluationListener> getCustomPostDecisionTableEvaluationListeners() {
        return this.customPostDecisionTableEvaluationListeners;
    }

    @Override
    public void setCustomPostDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.customPostDecisionTableEvaluationListeners = decisionTableEvaluationListeners;
    }

    @Override
    public DefaultDmnEngineConfiguration customPostDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.setCustomPostDecisionTableEvaluationListeners(decisionTableEvaluationListeners);
        return this;
    }

    @Override
    public List<DmnDecisionEvaluationListener> getCustomPreDecisionEvaluationListeners() {
        return this.customPreDecisionEvaluationListeners;
    }

    @Override
    public void setCustomPreDecisionEvaluationListeners(List<DmnDecisionEvaluationListener> decisionEvaluationListeners) {
        this.customPreDecisionEvaluationListeners = decisionEvaluationListeners;
    }

    @Override
    public DefaultDmnEngineConfiguration customPreDecisionEvaluationListeners(List<DmnDecisionEvaluationListener> decisionEvaluationListeners) {
        this.setCustomPreDecisionEvaluationListeners(decisionEvaluationListeners);
        return this;
    }

    @Override
    public List<DmnDecisionEvaluationListener> getCustomPostDecisionEvaluationListeners() {
        return this.customPostDecisionEvaluationListeners;
    }

    @Override
    public void setCustomPostDecisionEvaluationListeners(List<DmnDecisionEvaluationListener> decisionEvaluationListeners) {
        this.customPostDecisionEvaluationListeners = decisionEvaluationListeners;
    }

    @Override
    public DefaultDmnEngineConfiguration customPostDecisionEvaluationListeners(List<DmnDecisionEvaluationListener> decisionEvaluationListeners) {
        this.setCustomPostDecisionEvaluationListeners(decisionEvaluationListeners);
        return this;
    }

    public List<DmnDecisionTableEvaluationListener> getDecisionTableEvaluationListeners() {
        return this.decisionTableEvaluationListeners;
    }

    public List<DmnDecisionEvaluationListener> getDecisionEvaluationListeners() {
        return this.decisionEvaluationListeners;
    }

    public DmnScriptEngineResolver getScriptEngineResolver() {
        return this.scriptEngineResolver;
    }

    public void setScriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
    }

    public DefaultDmnEngineConfiguration scriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.setScriptEngineResolver(scriptEngineResolver);
        return this;
    }

    public ElProvider getElProvider() {
        return this.elProvider;
    }

    public void setElProvider(ElProvider elProvider) {
        this.elProvider = elProvider;
    }

    public DefaultDmnEngineConfiguration elProvider(ElProvider elProvider) {
        this.setElProvider(elProvider);
        return this;
    }

    public FeelEngineFactory getFeelEngineFactory() {
        return this.feelEngineFactory;
    }

    public void setFeelEngineFactory(FeelEngineFactory feelEngineFactory) {
        this.feelEngineFactory = feelEngineFactory;
        this.feelEngine = null;
    }

    public DefaultDmnEngineConfiguration feelEngineFactory(FeelEngineFactory feelEngineFactory) {
        this.setFeelEngineFactory(feelEngineFactory);
        return this;
    }

    public FeelEngine getFeelEngine() {
        return this.feelEngine;
    }

    public String getDefaultInputExpressionExpressionLanguage() {
        return this.defaultInputExpressionExpressionLanguage;
    }

    public void setDefaultInputExpressionExpressionLanguage(String expressionLanguage) {
        this.defaultInputExpressionExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultInputExpressionExpressionLanguage(String expressionLanguage) {
        this.setDefaultInputExpressionExpressionLanguage(expressionLanguage);
        return this;
    }

    public String getDefaultInputEntryExpressionLanguage() {
        return this.defaultInputEntryExpressionLanguage;
    }

    public void setDefaultInputEntryExpressionLanguage(String expressionLanguage) {
        this.defaultInputEntryExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultInputEntryExpressionLanguage(String expressionLanguage) {
        this.setDefaultInputEntryExpressionLanguage(expressionLanguage);
        return this;
    }

    public String getDefaultOutputEntryExpressionLanguage() {
        return this.defaultOutputEntryExpressionLanguage;
    }

    public void setDefaultOutputEntryExpressionLanguage(String expressionLanguage) {
        this.defaultOutputEntryExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultOutputEntryExpressionLanguage(String expressionLanguage) {
        this.setDefaultOutputEntryExpressionLanguage(expressionLanguage);
        return this;
    }

    public String getDefaultLiteralExpressionLanguage() {
        return this.defaultLiteralExpressionLanguage;
    }

    public void setDefaultLiteralExpressionLanguage(String expressionLanguage) {
        this.defaultLiteralExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultLiteralExpressionLanguage(String expressionLanguage) {
        this.setDefaultLiteralExpressionLanguage(expressionLanguage);
        return this;
    }

    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DmnTransformer transformer) {
        this.transformer = transformer;
    }

    public DefaultDmnEngineConfiguration transformer(DmnTransformer transformer) {
        this.setTransformer(transformer);
        return this;
    }

    public List<FeelCustomFunctionProvider> getFeelCustomFunctionProviders() {
        return this.feelCustomFunctionProviders;
    }

    public void setFeelCustomFunctionProviders(List<FeelCustomFunctionProvider> feelCustomFunctionProviders) {
        this.feelCustomFunctionProviders = feelCustomFunctionProviders;
    }

    public DefaultDmnEngineConfiguration feelCustomFunctionProviders(List<FeelCustomFunctionProvider> feelCustomFunctionProviders) {
        this.setFeelCustomFunctionProviders(feelCustomFunctionProviders);
        return this;
    }

    public boolean isEnableFeelLegacyBehavior() {
        return this.enableFeelLegacyBehavior;
    }

    public void setEnableFeelLegacyBehavior(boolean enableFeelLegacyBehavior) {
        this.enableFeelLegacyBehavior = enableFeelLegacyBehavior;
    }

    public DefaultDmnEngineConfiguration enableFeelLegacyBehavior(boolean enableFeelLegacyBehavior) {
        this.setEnableFeelLegacyBehavior(enableFeelLegacyBehavior);
        return this;
    }

    public boolean isReturnBlankTableOutputAsNull() {
        return this.returnBlankTableOutputAsNull;
    }

    public DefaultDmnEngineConfiguration setReturnBlankTableOutputAsNull(boolean returnBlankTableOutputAsNull) {
        this.returnBlankTableOutputAsNull = returnBlankTableOutputAsNull;
        return this;
    }
}

