/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.dmn.engine.DmnDecision;
import org.operaton.bpm.dmn.engine.DmnDecisionLogic;
import org.operaton.bpm.dmn.engine.DmnDecisionResult;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionEvaluationListener;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import org.operaton.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionLiteralExpressionImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.operaton.bpm.dmn.engine.impl.DmnEngineLogger;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnDecisionEvaluationEventImpl;
import org.operaton.bpm.dmn.engine.impl.evaluation.DecisionLiteralExpressionEvaluationHandler;
import org.operaton.bpm.dmn.engine.impl.evaluation.DecisionTableEvaluationHandler;
import org.operaton.bpm.dmn.engine.impl.evaluation.DmnDecisionLogicEvaluationHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.HitPolicyEntry;
import org.operaton.bpm.engine.variable.VariableMap;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.context.VariableContext;
import org.operaton.bpm.model.dmn.HitPolicy;

public class DefaultDmnDecisionContext {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected static final HitPolicyEntry COLLECT_HIT_POLICY = new HitPolicyEntry(HitPolicy.COLLECT, null);
    protected static final HitPolicyEntry RULE_ORDER_HIT_POLICY = new HitPolicyEntry(HitPolicy.RULE_ORDER, null);
    protected final List<DmnDecisionEvaluationListener> evaluationListeners;
    protected final Map<Class<? extends DmnDecisionLogic>, DmnDecisionLogicEvaluationHandler> evaluationHandlers;

    public DefaultDmnDecisionContext(DefaultDmnEngineConfiguration configuration) {
        this.evaluationListeners = configuration.getDecisionEvaluationListeners();
        this.evaluationHandlers = new HashMap<Class<? extends DmnDecisionLogic>, DmnDecisionLogicEvaluationHandler>();
        this.evaluationHandlers.put(DmnDecisionTableImpl.class, new DecisionTableEvaluationHandler(configuration));
        this.evaluationHandlers.put(DmnDecisionLiteralExpressionImpl.class, new DecisionLiteralExpressionEvaluationHandler(configuration));
    }

    public DmnDecisionResult evaluateDecision(DmnDecision decision, VariableContext variableContext) {
        if (decision.getKey() == null) {
            throw LOG.unableToFindAnyDecisionTable();
        }
        VariableMap variableMap = this.buildVariableMapFromVariableContext(variableContext);
        ArrayList<DmnDecision> requiredDecisions = new ArrayList<DmnDecision>();
        this.buildDecisionTree(decision, requiredDecisions);
        ArrayList<DmnDecisionLogicEvaluationEvent> evaluatedEvents = new ArrayList<DmnDecisionLogicEvaluationEvent>();
        DmnDecisionResult evaluatedResult = null;
        for (DmnDecision evaluateDecision : requiredDecisions) {
            DmnDecisionLogicEvaluationHandler handler = this.getDecisionEvaluationHandler(evaluateDecision);
            DmnDecisionLogicEvaluationEvent evaluatedEvent = handler.evaluate(evaluateDecision, variableMap.asVariableContext());
            evaluatedEvents.add(evaluatedEvent);
            evaluatedResult = handler.generateDecisionResult(evaluatedEvent);
            if (decision == evaluateDecision) continue;
            this.addResultToVariableContext(evaluatedResult, variableMap, evaluateDecision);
        }
        this.generateDecisionEvaluationEvent(evaluatedEvents);
        return evaluatedResult;
    }

    protected VariableMap buildVariableMapFromVariableContext(VariableContext variableContext) {
        VariableMap variableMap = Variables.createVariables();
        Set variables = variableContext.keySet();
        for (String variable : variables) {
            variableMap.put((Object)variable, (Object)variableContext.resolve(variable));
        }
        return variableMap;
    }

    protected void buildDecisionTree(DmnDecision decision, List<DmnDecision> requiredDecisions) {
        if (requiredDecisions.contains(decision)) {
            return;
        }
        for (DmnDecision dmnDecision : decision.getRequiredDecisions()) {
            this.buildDecisionTree(dmnDecision, requiredDecisions);
        }
        requiredDecisions.add(decision);
    }

    protected DmnDecisionLogicEvaluationHandler getDecisionEvaluationHandler(DmnDecision decision) {
        Class<?> key = decision.getDecisionLogic().getClass();
        if (this.evaluationHandlers.containsKey(key)) {
            return this.evaluationHandlers.get(key);
        }
        throw LOG.decisionLogicTypeNotSupported(decision.getDecisionLogic());
    }

    protected void addResultToVariableContext(DmnDecisionResult evaluatedResult, VariableMap variableMap, DmnDecision evaluatedDecision) {
        List<Map<String, Object>> resultList = evaluatedResult.getResultList();
        if (resultList.isEmpty()) {
            return;
        }
        if (resultList.size() == 1 && !this.isDecisionTableWithCollectOrRuleOrderHitPolicy(evaluatedDecision)) {
            variableMap.putAll((Map)evaluatedResult.getSingleResult());
        } else {
            HashSet<String> outputs = new HashSet<String>();
            for (Map<String, Object> resultMap : resultList) {
                outputs.addAll(resultMap.keySet());
            }
            for (String output : outputs) {
                List values = evaluatedResult.collectEntries(output);
                variableMap.put((Object)output, values);
            }
        }
    }

    protected boolean isDecisionTableWithCollectOrRuleOrderHitPolicy(DmnDecision evaluatedDecision) {
        boolean isDecisionTableWithCollectHitPolicy = false;
        if (evaluatedDecision.isDecisionTable()) {
            DmnDecisionTableImpl decisionTable = (DmnDecisionTableImpl)evaluatedDecision.getDecisionLogic();
            isDecisionTableWithCollectHitPolicy = COLLECT_HIT_POLICY.equals(decisionTable.getHitPolicyHandler().getHitPolicyEntry()) || RULE_ORDER_HIT_POLICY.equals(decisionTable.getHitPolicyHandler().getHitPolicyEntry());
        }
        return isDecisionTableWithCollectHitPolicy;
    }

    protected void generateDecisionEvaluationEvent(List<DmnDecisionLogicEvaluationEvent> evaluatedEvents) {
        DmnDecisionLogicEvaluationEvent rootEvaluatedEvent = null;
        DmnDecisionEvaluationEventImpl decisionEvaluationEvent = new DmnDecisionEvaluationEventImpl();
        long executedDecisionElements = 0L;
        for (DmnDecisionLogicEvaluationEvent evaluatedEvent : evaluatedEvents) {
            executedDecisionElements += evaluatedEvent.getExecutedDecisionElements();
            rootEvaluatedEvent = evaluatedEvent;
        }
        decisionEvaluationEvent.setDecisionResult(rootEvaluatedEvent);
        decisionEvaluationEvent.setExecutedDecisionInstances(evaluatedEvents.size());
        decisionEvaluationEvent.setExecutedDecisionElements(executedDecisionElements);
        evaluatedEvents.remove(rootEvaluatedEvent);
        decisionEvaluationEvent.setRequiredDecisionResults(evaluatedEvents);
        for (DmnDecisionEvaluationListener evaluationListener : this.evaluationListeners) {
            evaluationListener.notify(decisionEvaluationEvent);
        }
    }
}

