/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import org.opensaml.xml.signature.X509Digest;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class X509DigestSchemaValidator
implements Validator<X509Digest> {
    @Override
    public void validate(X509Digest xmlObject) throws ValidationException {
        this.validateContent(xmlObject);
    }

    protected void validateContent(X509Digest xmlObject) throws ValidationException {
        if (xmlObject.getValue() == null) {
            throw new ValidationException("X509Digest did not contain a value");
        }
        if (DatatypeHelper.isEmpty(xmlObject.getAlgorithm())) {
            throw new ValidationException("X509Digest did not contain Algorithm attribute");
        }
    }
}

