/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.saml.saml1.core.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.saml1.core.Conditions;
import org.w3c.dom.Element;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;

/**
 * A thread safe Marshaller for {@link org.opensaml.saml.saml2.core.Conditions} objects.
 */
public class ConditionsMarshaller extends AbstractSAMLObjectMarshaller {

    /** {@inheritDoc} */
    protected void marshallAttributes(final XMLObject samlElement, final Element domElement)
            throws MarshallingException {

        final Conditions conditions = (Conditions) samlElement;

        if (conditions.getNotBefore() != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, Conditions.NOTBEFORE_ATTRIB_QNAME,
                    conditions.getNotBefore());
        }

        if (conditions.getNotOnOrAfter() != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, Conditions.NOTONORAFTER_ATTRIB_QNAME,
                    conditions.getNotOnOrAfter());
        }
    }

}