/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.merge;

import java.io.IOException;
import java.text.MessageFormat;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.NoMergeBaseException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.NullProgressMonitor;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectInserter;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevObject;
import org.openrewrite.jgit.revwalk.RevTree;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.revwalk.filter.RevFilter;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.jgit.treewalk.CanonicalTreeParser;

public abstract class Merger {
    @Nullable
    protected final Repository db;
    protected ObjectReader reader;
    protected RevWalk walk;
    private ObjectInserter inserter;
    protected RevObject[] sourceObjects;
    protected RevCommit[] sourceCommits;
    protected RevTree[] sourceTrees;
    protected ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected Merger(Repository local) {
        if (local == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        this.db = local;
        this.inserter = local.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.walk = new RevWalk(this.reader);
    }

    protected Merger(ObjectInserter oi) {
        this.db = null;
        this.inserter = oi;
        this.reader = oi.newReader();
        this.walk = new RevWalk(this.reader);
    }

    @Nullable
    public Repository getRepository() {
        return this.db;
    }

    protected Repository nonNullRepo() {
        if (this.db == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        return this.db;
    }

    public ObjectInserter getObjectInserter() {
        return this.inserter;
    }

    public void setObjectInserter(ObjectInserter oi) {
        this.walk.close();
        this.reader.close();
        this.inserter.close();
        this.inserter = oi;
        this.reader = oi.newReader();
        this.walk = new RevWalk(this.reader);
    }

    public boolean merge(AnyObjectId ... tips) throws IOException {
        return this.merge(true, tips);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean merge(boolean flush, AnyObjectId ... tips) throws IOException {
        int i;
        this.sourceObjects = new RevObject[tips.length];
        for (i = 0; i < tips.length; ++i) {
            this.sourceObjects[i] = this.walk.parseAny(tips[i]);
        }
        this.sourceCommits = new RevCommit[this.sourceObjects.length];
        for (i = 0; i < this.sourceObjects.length; ++i) {
            try {
                this.sourceCommits[i] = this.walk.parseCommit(this.sourceObjects[i]);
                continue;
            }
            catch (IncorrectObjectTypeException err) {
                this.sourceCommits[i] = null;
            }
        }
        this.sourceTrees = new RevTree[this.sourceObjects.length];
        for (i = 0; i < this.sourceObjects.length; ++i) {
            this.sourceTrees[i] = this.walk.parseTree(this.sourceObjects[i]);
        }
        try {
            boolean ok = this.mergeImpl();
            if (ok && flush) {
                this.inserter.flush();
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            if (flush) {
                this.inserter.close();
            }
            this.reader.close();
        }
    }

    public abstract ObjectId getBaseCommitId();

    protected RevCommit getBaseCommit(RevCommit a, RevCommit b) throws IncorrectObjectTypeException, IOException {
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(a);
        this.walk.markStart(b);
        RevCommit base = this.walk.next();
        if (base == null) {
            return null;
        }
        RevCommit base2 = this.walk.next();
        if (base2 != null) {
            throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.MULTIPLE_MERGE_BASES_NOT_SUPPORTED, MessageFormat.format(JGitText.get().multipleMergeBasesFor, a.name(), b.name(), base.name(), base2.name()));
        }
        return base;
    }

    protected AbstractTreeIterator openTree(AnyObjectId treeId) throws IncorrectObjectTypeException, IOException {
        return new CanonicalTreeParser(null, this.reader, treeId);
    }

    protected abstract boolean mergeImpl() throws IOException;

    public abstract ObjectId getResultTreeId();

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor == null ? NullProgressMonitor.INSTANCE : monitor;
    }
}

