/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.errors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.jgit.errors.TransportException;
import org.openrewrite.jgit.transport.URIish;

public class HttpResponseException
extends TransportException {
    private static final long serialVersionUID = 1L;
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final String responseBody;

    public HttpResponseException(URIish uri, int statusCode, Map<String, List<String>> headers, String responseBody, String message) {
        super(uri, message);
        this.statusCode = statusCode;
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.responseBody = responseBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getHeader(String name) {
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            List<String> values = entry.getValue();
            return values != null && !values.isEmpty() ? values.get(0) : null;
        }
        return null;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

