/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.openrewrite.jgit.diff.ContentSource;
import org.openrewrite.jgit.diff.DiffEntry;
import org.openrewrite.jgit.diff.RenameDetector;
import org.openrewrite.jgit.diff.SimilarityIndex;
import org.openrewrite.jgit.errors.CancelledException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.NullProgressMonitor;
import org.openrewrite.jgit.lib.ObjectLoader;
import org.openrewrite.jgit.lib.ProgressMonitor;

class SimilarityRenameDetector {
    private static final int BITS_PER_INDEX = 28;
    private static final int INDEX_MASK = 0xFFFFFFF;
    private static final int SCORE_SHIFT = 56;
    private ContentSource.Pair reader;
    private List<DiffEntry> srcs;
    private List<DiffEntry> dsts;
    private long[] matrix;
    private int renameScore = 60;
    private int bigFileThreshold = 0x3200000;
    private boolean skipBinaryFiles = false;
    private boolean tableOverflow;
    private List<DiffEntry> out;

    SimilarityRenameDetector(ContentSource.Pair reader, List<DiffEntry> srcs, List<DiffEntry> dsts) {
        this.reader = reader;
        this.srcs = srcs;
        this.dsts = dsts;
    }

    void setRenameScore(int score) {
        this.renameScore = score;
    }

    void setBigFileThreshold(int threshold) {
        this.bigFileThreshold = threshold;
    }

    void setSkipBinaryFiles(boolean value) {
        this.skipBinaryFiles = value;
    }

    void compute(ProgressMonitor pm) throws IOException, CancelledException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        pm.beginTask(JGitText.get().renamesFindingByContent, 2 * this.srcs.size() * this.dsts.size());
        int mNext = this.buildMatrix(pm);
        this.out = new ArrayList<DiffEntry>(Math.min(mNext, this.dsts.size()));
        --mNext;
        while (mNext >= 0) {
            if (pm.isCancelled()) {
                throw new CancelledException(JGitText.get().renameCancelled);
            }
            long ent = this.matrix[mNext];
            int sIdx = SimilarityRenameDetector.srcFile(ent);
            int dIdx = SimilarityRenameDetector.dstFile(ent);
            DiffEntry s = this.srcs.get(sIdx);
            DiffEntry d = this.dsts.get(dIdx);
            if (d == null) {
                pm.update(1);
            } else {
                DiffEntry.ChangeType type;
                if (s.changeType == DiffEntry.ChangeType.DELETE) {
                    s.changeType = DiffEntry.ChangeType.RENAME;
                    type = DiffEntry.ChangeType.RENAME;
                } else {
                    type = DiffEntry.ChangeType.COPY;
                }
                this.out.add(DiffEntry.pair(type, s, d, SimilarityRenameDetector.score(ent)));
                this.dsts.set(dIdx, null);
                pm.update(1);
            }
            --mNext;
        }
        this.srcs = SimilarityRenameDetector.compactSrcList(this.srcs);
        this.dsts = SimilarityRenameDetector.compactDstList(this.dsts);
        pm.endTask();
    }

    List<DiffEntry> getMatches() {
        return this.out;
    }

    List<DiffEntry> getLeftOverSources() {
        return this.srcs;
    }

    List<DiffEntry> getLeftOverDestinations() {
        return this.dsts;
    }

    boolean isTableOverflow() {
        return this.tableOverflow;
    }

    private static List<DiffEntry> compactSrcList(List<DiffEntry> in) {
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>(in.size());
        for (DiffEntry e : in) {
            if (e.changeType != DiffEntry.ChangeType.DELETE) continue;
            r.add(e);
        }
        return r;
    }

    private static List<DiffEntry> compactDstList(List<DiffEntry> in) {
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>(in.size());
        for (DiffEntry e : in) {
            if (e == null) continue;
            r.add(e);
        }
        return r;
    }

    private int buildMatrix(ProgressMonitor pm) throws IOException, CancelledException {
        this.matrix = new long[this.srcs.size() * this.dsts.size()];
        long[] srcSizes = new long[this.srcs.size()];
        long[] dstSizes = new long[this.dsts.size()];
        BitSet dstTooLarge = null;
        int mNext = 0;
        block4: for (int srcIdx = 0; srcIdx < this.srcs.size(); ++srcIdx) {
            DiffEntry srcEnt = this.srcs.get(srcIdx);
            if (!SimilarityRenameDetector.isFile(srcEnt.oldMode)) {
                pm.update(this.dsts.size());
                continue;
            }
            SimilarityIndex s = null;
            for (int dstIdx = 0; dstIdx < this.dsts.size(); ++dstIdx) {
                SimilarityIndex d;
                long dstSize;
                if (pm.isCancelled()) {
                    throw new CancelledException(JGitText.get().renameCancelled);
                }
                DiffEntry dstEnt = this.dsts.get(dstIdx);
                if (!SimilarityRenameDetector.isFile(dstEnt.newMode)) {
                    pm.update(1);
                    continue;
                }
                if (!RenameDetector.sameType(srcEnt.oldMode, dstEnt.newMode)) {
                    pm.update(1);
                    continue;
                }
                if (dstTooLarge != null && dstTooLarge.get(dstIdx)) {
                    pm.update(1);
                    continue;
                }
                long srcSize = srcSizes[srcIdx];
                if (srcSize == 0L) {
                    srcSizes[srcIdx] = srcSize = this.size(DiffEntry.Side.OLD, srcEnt) + 1L;
                }
                if ((dstSize = dstSizes[dstIdx]) == 0L) {
                    dstSizes[dstIdx] = dstSize = this.size(DiffEntry.Side.NEW, dstEnt) + 1L;
                }
                long max = Math.max(srcSize, dstSize);
                long min = Math.min(srcSize, dstSize);
                if (min * 100L / max < (long)this.renameScore) {
                    pm.update(1);
                    continue;
                }
                if (max > (long)this.bigFileThreshold) {
                    pm.update(1);
                    continue;
                }
                if (s == null) {
                    try {
                        ObjectLoader loader = this.reader.open(DiffEntry.Side.OLD, srcEnt);
                        if (this.skipBinaryFiles && SimilarityIndex.isBinary(loader)) {
                            pm.update(1);
                            continue block4;
                        }
                        s = this.hash(loader);
                    }
                    catch (SimilarityIndex.TableFullException tableFull) {
                        this.tableOverflow = true;
                        continue block4;
                    }
                }
                try {
                    ObjectLoader loader = this.reader.open(DiffEntry.Side.NEW, dstEnt);
                    if (this.skipBinaryFiles && SimilarityIndex.isBinary(loader)) {
                        pm.update(1);
                        continue;
                    }
                    d = this.hash(loader);
                }
                catch (SimilarityIndex.TableFullException tableFull) {
                    if (dstTooLarge == null) {
                        dstTooLarge = new BitSet(this.dsts.size());
                    }
                    dstTooLarge.set(dstIdx);
                    this.tableOverflow = true;
                    pm.update(1);
                    continue;
                }
                int contentScore = s.score(d, 10000);
                int nameScore = SimilarityRenameDetector.nameScore(srcEnt.oldPath, dstEnt.newPath) * 100;
                int score = (contentScore * 99 + nameScore * 1) / 10000;
                if (score < this.renameScore) {
                    pm.update(1);
                    continue;
                }
                this.matrix[mNext++] = SimilarityRenameDetector.encode(score, srcIdx, dstIdx);
                pm.update(1);
            }
        }
        Arrays.sort(this.matrix, 0, mNext);
        return mNext;
    }

    static int nameScore(String a, String b) {
        int fileSim;
        int dirScoreRtl;
        int dirScoreLtr;
        int aDirLen = a.lastIndexOf(47) + 1;
        int bDirLen = b.lastIndexOf(47) + 1;
        int dirMin = Math.min(aDirLen, bDirLen);
        int dirMax = Math.max(aDirLen, bDirLen);
        if (dirMax == 0) {
            dirScoreLtr = 100;
            dirScoreRtl = 100;
        } else {
            int dirSim;
            for (dirSim = 0; dirSim < dirMin && a.charAt(dirSim) == b.charAt(dirSim); ++dirSim) {
            }
            dirScoreLtr = dirSim * 100 / dirMax;
            if (dirScoreLtr == 100) {
                dirScoreRtl = 100;
            } else {
                for (dirSim = 0; dirSim < dirMin && a.charAt(aDirLen - 1 - dirSim) == b.charAt(bDirLen - 1 - dirSim); ++dirSim) {
                }
                dirScoreRtl = dirSim * 100 / dirMax;
            }
        }
        int fileMin = Math.min(a.length() - aDirLen, b.length() - bDirLen);
        int fileMax = Math.max(a.length() - aDirLen, b.length() - bDirLen);
        for (fileSim = 0; fileSim < fileMin && a.charAt(a.length() - 1 - fileSim) == b.charAt(b.length() - 1 - fileSim); ++fileSim) {
        }
        int fileScore = fileSim * 100 / fileMax;
        return ((dirScoreLtr + dirScoreRtl) * 25 + fileScore * 50) / 100;
    }

    private SimilarityIndex hash(ObjectLoader objectLoader) throws IOException, SimilarityIndex.TableFullException {
        SimilarityIndex r = new SimilarityIndex();
        r.hash(objectLoader);
        r.sort();
        return r;
    }

    private long size(DiffEntry.Side side, DiffEntry ent) throws IOException {
        return this.reader.size(side, ent);
    }

    private static int score(long value) {
        return (int)(value >>> 56);
    }

    static int srcFile(long value) {
        return SimilarityRenameDetector.decodeFile((int)(value >>> 28) & 0xFFFFFFF);
    }

    static int dstFile(long value) {
        return SimilarityRenameDetector.decodeFile((int)value & 0xFFFFFFF);
    }

    static long encode(int score, int srcIdx, int dstIdx) {
        return (long)score << 56 | SimilarityRenameDetector.encodeFile(srcIdx) << 28 | SimilarityRenameDetector.encodeFile(dstIdx);
    }

    private static long encodeFile(int idx) {
        return 0xFFFFFFF - idx;
    }

    private static int decodeFile(int v) {
        return 0xFFFFFFF - v;
    }

    private static boolean isFile(FileMode mode) {
        return (mode.getBits() & 0xF000) == 32768;
    }
}

