/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.Optional;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class MergeYaml
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression used to find matching keys.", example="$.metadata")
    private final String key;
    @Option(displayName="YAML snippet", description="The YAML snippet to insert. The snippet will be indented to match the style of its surroundings.", example="labels:\n  label-one: \"value-one\"")
    @Language(value="yml")
    private final String yaml;
    @Option(displayName="Accept theirs", description="When the YAML snippet to insert conflicts with an existing key value pair and an existing key has a different value, prefer the original value.", required=false)
    private final @Nullable Boolean acceptTheirs;
    @Option(displayName="Object identifying property", description="Name of a property which will be used to identify objects (mapping). This serves as the key to match on when merging entries of a sequence.", required=false, example="name")
    @Incubating(since="7.30.0")
    private final @Nullable String objectIdentifyingProperty;
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.", required=false, example=".github/workflows/*.yml")
    private final @Nullable String filePattern;
    @Option(displayName="Insert mode", description="Choose an insertion point when multiple mappings exist. Default is `Last`.", valid={"Before", "After", "Last"}, required=false)
    private final @Nullable InsertMode insertMode;
    @Option(displayName="Insert property", description="Define the key for the insertion mode. Takes the `key` JsonPath into account. Only useful when `insert mode` is either `Before` or `After`.", required=false, example="some-key")
    private final @Nullable String insertProperty;
    @Option(displayName="Create new keys", description="When the key path does _not_ match any keys, create new keys on the spot. Default is `true`.", required=false)
    private final @Nullable Boolean createNewKeys;
    private transient @Nullable Yaml incoming = null;
    private final String displayName = "Merge YAML snippet";
    private final String description = "Merge a YAML snippet with an existing YAML document.";
    static final String FOUND_MATCHING_ELEMENT = "FOUND_MATCHING_ELEMENT";
    static final String REMOVE_PREFIX = "REMOVE_PREFIX";

    public MergeYaml(String key, @Language(value="yml") String yaml, @Nullable Boolean acceptTheirs, @Nullable String objectIdentifyingProperty, @Nullable String filePattern, @Nullable InsertMode insertMode, @Nullable String insertProperty, @Nullable Boolean createNewKeys) {
        this.key = key;
        this.yaml = yaml;
        this.acceptTheirs = acceptTheirs;
        this.objectIdentifyingProperty = objectIdentifyingProperty;
        this.filePattern = filePattern;
        this.insertMode = insertMode;
        this.insertProperty = insertProperty;
        this.createNewKeys = createNewKeys;
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"yaml", (String)"Must be valid YAML", (Object)this.yaml, y -> {
            if (this.yaml == null) {
                return false;
            }
            MergeYaml.maybeParse(this.yaml).ifPresent(it -> {
                this.incoming = it;
            });
            return this.incoming != null;
        })).and(Validated.required((String)"key", (Object)this.key)).and(Validated.test((String)"insertProperty", (String)"Insert property must be filed when `insert mode` is either `BeforeProperty` or `AfterProperty`.", (Object)this.insertProperty, s -> this.insertMode == null || this.insertMode == InsertMode.Last || !StringUtils.isBlank((String)s)));
    }

    public String getInstanceNameSuffix() {
        return String.format("at `%s`", this.key);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        if (this.incoming == null) {
            this.incoming = MergeYaml.parse(this.yaml);
        }
        return Preconditions.check((Recipe)new FindSourceFiles(this.filePattern), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            private final boolean accptTheirs;
            private final JsonPathMatcher matcher;
            {
                this.accptTheirs = Boolean.TRUE.equals(MergeYaml.this.acceptTheirs);
                this.matcher = new JsonPathMatcher(MergeYaml.this.key);
            }

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if ("$".equals(MergeYaml.this.key)) {
                    Yaml.Document d = document.withBlock((Yaml.Block)new MergeYamlVisitor(document.getBlock(), MergeYaml.this.incoming, this.accptTheirs, MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertMode, MergeYaml.this.insertProperty).visitNonNull(document.getBlock(), ctx, this.getCursor()));
                    if (((Boolean)this.getCursor().getMessage(MergeYaml.REMOVE_PREFIX, (Object)false)).booleanValue()) {
                        d = MergeYaml.this.insertMode == InsertMode.Before ? d.withPrefix("") : d.withEnd(d.getEnd().withPrefix(this.preserveDocumentSeparator(d)));
                    }
                    return d;
                }
                Yaml d = super.visitDocument(document, ctx);
                if ((MergeYaml.this.createNewKeys == null || Boolean.TRUE.equals(MergeYaml.this.createNewKeys)) && d == document && !((Boolean)this.getCursor().getMessage(MergeYaml.FOUND_MATCHING_ELEMENT, (Object)false)).booleanValue()) {
                    String valueKey = this.maybeKeyFromJsonPath(MergeYaml.this.key);
                    if (valueKey == null) {
                        return d;
                    }
                    String snippet = MergeYaml.this.incoming instanceof Yaml.Mapping ? valueKey + ":\n  " + MergeYaml.this.yaml.replaceAll("\n", "\n  ") : valueKey + ":" + (MergeYaml.this.yaml.startsWith(" ") ? MergeYaml.this.yaml : " " + MergeYaml.this.yaml);
                    return ((Yaml.Document)d).withBlock((Yaml.Block)new MergeYamlVisitor(((Yaml.Document)d).getBlock(), MergeYaml.parse(snippet), this.accptTheirs, MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertMode, MergeYaml.this.insertProperty).visitNonNull(((Yaml.Document)d).getBlock(), ctx, this.getCursor()));
                }
                if (((Boolean)this.getCursor().getMessage(MergeYaml.REMOVE_PREFIX, (Object)false)).booleanValue()) {
                    d = ((Yaml.Document)d).withEnd(((Yaml.Document)d).getEnd().withPrefix(this.preserveDocumentSeparator((Yaml.Document)d)));
                }
                return d;
            }

            private String preserveDocumentSeparator(Yaml.Document document) {
                Yaml.Documents documents = (Yaml.Documents)this.getCursor().firstEnclosing(Yaml.Documents.class);
                if (documents != null) {
                    int currentIndex = documents.getDocuments().indexOf(document);
                    if (0 <= currentIndex && currentIndex < documents.getDocuments().size() - 1 && documents.getDocuments().get(currentIndex + 1).isExplicit()) {
                        return "\n";
                    }
                    if (currentIndex == documents.getDocuments().size() - 1 && document.getEnd().isExplicit()) {
                        return "\n";
                    }
                }
                return "";
            }

            private @Nullable String maybeKeyFromJsonPath(String jsonPath) {
                if (!jsonPath.startsWith("$.")) {
                    return null;
                }
                if (jsonPath.matches(".*\\[\\s?\\?\\s?\\(\\s?@\\..*\\)\\s?].*")) {
                    return null;
                }
                if (jsonPath.matches(".*\\*.*") || jsonPath.matches(".*\\.\\..*")) {
                    return null;
                }
                return jsonPath.substring(2);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml m = super.visitMapping(mapping, ctx);
                if (this.matcher.matches(this.getCursor())) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, MergeYaml.FOUND_MATCHING_ELEMENT, (Object)true);
                    m = (Yaml.Mapping)new MergeYamlVisitor(mapping, MergeYaml.this.incoming, this.accptTheirs, MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertMode, MergeYaml.this.insertProperty).visitNonNull(mapping, ctx, this.getCursor().getParentOrThrow());
                }
                return m;
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (this.matcher.matches(this.getCursor())) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, MergeYaml.FOUND_MATCHING_ELEMENT, (Object)true);
                    Yaml.Block value = (Yaml.Block)new MergeYamlVisitor(entry.getValue(), MergeYaml.this.incoming, this.accptTheirs, MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertMode, MergeYaml.this.insertProperty).visitNonNull(entry.getValue(), ctx, this.getCursor());
                    if (value instanceof Yaml.Scalar && value.getPrefix().isEmpty()) {
                        value = value.withPrefix(" ");
                    }
                    return entry.withValue(value);
                }
                return super.visitMappingEntry(entry, ctx);
            }

            @Override
            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                if (this.matcher.matches(this.getCursor().getParentOrThrow())) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, MergeYaml.FOUND_MATCHING_ELEMENT, (Object)true);
                    return sequence.withEntries(ListUtils.map(sequence.getEntries(), entry -> entry.withBlock((Yaml.Block)new MergeYamlVisitor(entry.getBlock(), MergeYaml.this.incoming, this.accptTheirs, MergeYaml.this.objectIdentifyingProperty, MergeYaml.this.insertMode, MergeYaml.this.insertProperty).visitNonNull(entry.getBlock(), ctx, new Cursor(this.getCursor(), entry)))));
                }
                return super.visitSequence(sequence, ctx);
            }
        });
    }

    private static Optional<Yaml.Block> maybeParse(@Language(value="yml") String yaml) {
        return new YamlParser().parse(yaml).findFirst().filter(Yaml.Documents.class::isInstance).map(Yaml.Documents.class::cast).map(docs -> {
            Yaml.Document doc = docs.getDocuments().get(0);
            if (doc.getBlock() instanceof Yaml.Mapping) {
                Yaml.Mapping m = (Yaml.Mapping)doc.getBlock();
                return m.withEntries(ListUtils.mapFirst(m.getEntries(), entry -> entry.withPrefix(doc.getPrefix())));
            }
            if (doc.getBlock() instanceof Yaml.Sequence) {
                Yaml.Sequence s = (Yaml.Sequence)doc.getBlock();
                return s.withEntries(ListUtils.mapFirst(s.getEntries(), entry -> entry.withPrefix(doc.getPrefix())));
            }
            return doc.getBlock().withPrefix(doc.getPrefix());
        });
    }

    static Yaml parse(@Language(value="yml") String yaml) {
        return MergeYaml.maybeParse(yaml).orElseThrow(() -> new IllegalArgumentException("Could not parse as YAML"));
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Language(value="yml")
    @Generated
    public String getYaml() {
        return this.yaml;
    }

    @Generated
    public @Nullable Boolean getAcceptTheirs() {
        return this.acceptTheirs;
    }

    @Generated
    public @Nullable String getObjectIdentifyingProperty() {
        return this.objectIdentifyingProperty;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public @Nullable InsertMode getInsertMode() {
        return this.insertMode;
    }

    @Generated
    public @Nullable String getInsertProperty() {
        return this.insertProperty;
    }

    @Generated
    public @Nullable Boolean getCreateNewKeys() {
        return this.createNewKeys;
    }

    @Generated
    public @Nullable Yaml getIncoming() {
        return this.incoming;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MergeYaml(key=" + this.getKey() + ", yaml=" + this.getYaml() + ", acceptTheirs=" + this.getAcceptTheirs() + ", objectIdentifyingProperty=" + this.getObjectIdentifyingProperty() + ", filePattern=" + this.getFilePattern() + ", insertMode=" + (Object)((Object)this.getInsertMode()) + ", insertProperty=" + this.getInsertProperty() + ", createNewKeys=" + this.getCreateNewKeys() + ", incoming=" + this.getIncoming() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeYaml)) {
            return false;
        }
        MergeYaml other = (MergeYaml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$acceptTheirs = this.getAcceptTheirs();
        Boolean other$acceptTheirs = other.getAcceptTheirs();
        if (this$acceptTheirs == null ? other$acceptTheirs != null : !((Object)this$acceptTheirs).equals(other$acceptTheirs)) {
            return false;
        }
        Boolean this$createNewKeys = this.getCreateNewKeys();
        Boolean other$createNewKeys = other.getCreateNewKeys();
        if (this$createNewKeys == null ? other$createNewKeys != null : !((Object)this$createNewKeys).equals(other$createNewKeys)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$yaml = this.getYaml();
        String other$yaml = other.getYaml();
        if (this$yaml == null ? other$yaml != null : !this$yaml.equals(other$yaml)) {
            return false;
        }
        String this$objectIdentifyingProperty = this.getObjectIdentifyingProperty();
        String other$objectIdentifyingProperty = other.getObjectIdentifyingProperty();
        if (this$objectIdentifyingProperty == null ? other$objectIdentifyingProperty != null : !this$objectIdentifyingProperty.equals(other$objectIdentifyingProperty)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        InsertMode this$insertMode = this.getInsertMode();
        InsertMode other$insertMode = other.getInsertMode();
        if (this$insertMode == null ? other$insertMode != null : !((Object)((Object)this$insertMode)).equals((Object)other$insertMode)) {
            return false;
        }
        String this$insertProperty = this.getInsertProperty();
        String other$insertProperty = other.getInsertProperty();
        if (this$insertProperty == null ? other$insertProperty != null : !this$insertProperty.equals(other$insertProperty)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MergeYaml;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $acceptTheirs = this.getAcceptTheirs();
        result = result * 59 + ($acceptTheirs == null ? 43 : ((Object)$acceptTheirs).hashCode());
        Boolean $createNewKeys = this.getCreateNewKeys();
        result = result * 59 + ($createNewKeys == null ? 43 : ((Object)$createNewKeys).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $yaml = this.getYaml();
        result = result * 59 + ($yaml == null ? 43 : $yaml.hashCode());
        String $objectIdentifyingProperty = this.getObjectIdentifyingProperty();
        result = result * 59 + ($objectIdentifyingProperty == null ? 43 : $objectIdentifyingProperty.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        InsertMode $insertMode = this.getInsertMode();
        result = result * 59 + ($insertMode == null ? 43 : ((Object)((Object)$insertMode)).hashCode());
        String $insertProperty = this.getInsertProperty();
        result = result * 59 + ($insertProperty == null ? 43 : $insertProperty.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public MergeYaml() {
        this.key = null;
        this.yaml = null;
        this.acceptTheirs = null;
        this.objectIdentifyingProperty = null;
        this.filePattern = null;
        this.insertMode = null;
        this.insertProperty = null;
        this.createNewKeys = null;
    }

    public static enum InsertMode {
        Before,
        After,
        Last;

    }
}

