/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.AppendToSequenceVisitor;
import org.openrewrite.yaml.JsonPathMatcher;

public final class AppendToSequence
extends Recipe {
    @Option(displayName="Sequence path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a YAML sequence.", example="$.universe.planets")
    private final String sequencePath;
    @Option(displayName="New value", description="The new value to be appended to the sequence.", example="earth")
    private final String value;
    @Option(displayName="Optional: match existing sequence values", description="If specified, the item will only be appended if the existing sequence matches these values.", example="existingValue1", required=false)
    private final @Nullable List<String> existingSequenceValues;
    @Option(displayName="Optional: match existing sequence values in any order", description="If specified in combination with the above parameter, the item will only be appended if the existing sequence has the specified values in any order.", example="true", required=false)
    private final @Nullable Boolean matchExistingSequenceValuesInAnyOrder;
    private final String displayName = "Append to sequence";
    private final String description = "Append item to YAML sequence.";

    public String getInstanceName() {
        return String.format("Append %s to sequence `%s`", this.value, this.sequencePath);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JsonPathMatcher matcher = new JsonPathMatcher(this.sequencePath);
        return new AppendToSequenceVisitor(matcher, this.value, this.existingSequenceValues, Boolean.TRUE.equals(this.matchExistingSequenceValuesInAnyOrder));
    }

    @Generated
    public AppendToSequence(String sequencePath, String value, @Nullable List<String> existingSequenceValues, @Nullable Boolean matchExistingSequenceValuesInAnyOrder) {
        this.sequencePath = sequencePath;
        this.value = value;
        this.existingSequenceValues = existingSequenceValues;
        this.matchExistingSequenceValuesInAnyOrder = matchExistingSequenceValuesInAnyOrder;
    }

    @Generated
    public String getSequencePath() {
        return this.sequencePath;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public @Nullable List<String> getExistingSequenceValues() {
        return this.existingSequenceValues;
    }

    @Generated
    public @Nullable Boolean getMatchExistingSequenceValuesInAnyOrder() {
        return this.matchExistingSequenceValuesInAnyOrder;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AppendToSequence(sequencePath=" + this.getSequencePath() + ", value=" + this.getValue() + ", existingSequenceValues=" + this.getExistingSequenceValues() + ", matchExistingSequenceValuesInAnyOrder=" + this.getMatchExistingSequenceValuesInAnyOrder() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppendToSequence)) {
            return false;
        }
        AppendToSequence other = (AppendToSequence)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchExistingSequenceValuesInAnyOrder = this.getMatchExistingSequenceValuesInAnyOrder();
        Boolean other$matchExistingSequenceValuesInAnyOrder = other.getMatchExistingSequenceValuesInAnyOrder();
        if (this$matchExistingSequenceValuesInAnyOrder == null ? other$matchExistingSequenceValuesInAnyOrder != null : !((Object)this$matchExistingSequenceValuesInAnyOrder).equals(other$matchExistingSequenceValuesInAnyOrder)) {
            return false;
        }
        String this$sequencePath = this.getSequencePath();
        String other$sequencePath = other.getSequencePath();
        if (this$sequencePath == null ? other$sequencePath != null : !this$sequencePath.equals(other$sequencePath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<String> this$existingSequenceValues = this.getExistingSequenceValues();
        List<String> other$existingSequenceValues = other.getExistingSequenceValues();
        if (this$existingSequenceValues == null ? other$existingSequenceValues != null : !((Object)this$existingSequenceValues).equals(other$existingSequenceValues)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AppendToSequence;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchExistingSequenceValuesInAnyOrder = this.getMatchExistingSequenceValuesInAnyOrder();
        result = result * 59 + ($matchExistingSequenceValuesInAnyOrder == null ? 43 : ((Object)$matchExistingSequenceValuesInAnyOrder).hashCode());
        String $sequencePath = this.getSequencePath();
        result = result * 59 + ($sequencePath == null ? 43 : $sequencePath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<String> $existingSequenceValues = this.getExistingSequenceValues();
        result = result * 59 + ($existingSequenceValues == null ? 43 : ((Object)$existingSequenceValues).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

