/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.security.IsOwaspSuppressionsFile;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveOwaspSuppressions
extends Recipe {
    private final String displayName = "Remove out-of-date OWASP suppressions";
    @Option(displayName="Until date", required=false, description="Suppressions will be removed if they expired before the provided date. Default will be yesterday.", example="2023-01-01")
    private final @Nullable String cutOffDate;
    private final String description = "Remove all OWASP suppressions with a suppression end date in the past, as these are no longer valid. For use with the OWASP `dependency-check` tool. More details on OWASP suppression files can be found [here](https://jeremylong.github.io/DependencyCheck/general/suppression.html).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsOwaspSuppressionsFile(), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (!new XPathMatcher("/suppressions").matches(this.getCursor()) || ((Xml.Tag)t).getContent() == null) {
                    return t;
                }
                return ((Xml.Tag)t).withContent(ListUtils.map(((Xml.Tag)t).getContent(), c -> this.isPastDueSuppression((Content)c) ? null : c));
            }

            private boolean isPastDueSuppression(Content content) {
                Xml.Tag child;
                if (content instanceof Xml.Tag && "suppress".equals((child = (Xml.Tag)content).getName())) {
                    for (Xml.Attribute attribute : child.getAttributes()) {
                        if (!"until".equals(attribute.getKeyAsString())) continue;
                        String maybeDate = attribute.getValueAsString();
                        if (maybeDate.endsWith("Z")) {
                            maybeDate = maybeDate.substring(0, maybeDate.length() - 1);
                        }
                        try {
                            LocalDate date;
                            LocalDate maxDate = LocalDate.now().minusDays(1L);
                            if (RemoveOwaspSuppressions.this.cutOffDate != null) {
                                maxDate = LocalDate.parse(RemoveOwaspSuppressions.this.cutOffDate);
                            }
                            if (!(date = LocalDate.parse(maybeDate)).isBefore(maxDate)) continue;
                            return true;
                        }
                        catch (DateTimeParseException e) {
                            return false;
                        }
                    }
                }
                return false;
            }
        });
    }

    @Generated
    public RemoveOwaspSuppressions(@Nullable String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public @Nullable String getCutOffDate() {
        return this.cutOffDate;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveOwaspSuppressions(displayName=" + this.getDisplayName() + ", cutOffDate=" + this.getCutOffDate() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOwaspSuppressions)) {
            return false;
        }
        RemoveOwaspSuppressions other = (RemoveOwaspSuppressions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$cutOffDate = this.getCutOffDate();
        String other$cutOffDate = other.getCutOffDate();
        if (this$cutOffDate == null ? other$cutOffDate != null : !this$cutOffDate.equals(other$cutOffDate)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveOwaspSuppressions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $cutOffDate = this.getCutOffDate();
        result = result * 59 + ($cutOffDate == null ? 43 : $cutOffDate.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

