/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class IsOwaspSuppressionsFile
extends Recipe {
    final String displayName = "Find OWASP vulnerability suppression XML files";
    final String description = "These files are used to suppress false positives in OWASP [Dependency Check](https://jeremylong.github.io/DependencyCheck).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml doc = super.visitDocument(document, ctx);
                if (((Xml.Document)doc).getRoot() == null) {
                    return doc;
                }
                Xml.Tag root = ((Xml.Document)doc).getRoot();
                if (!"suppressions".equals(root.getName())) {
                    return doc;
                }
                boolean isOwaspSuppressionFile = false;
                for (Xml.Attribute attribute : root.getAttributes()) {
                    if (!"xmlns".equals(attribute.getKeyAsString()) || !attribute.getValueAsString().matches("https://jeremylong.github.io/DependencyCheck/dependency-suppression(.*?).xsd")) continue;
                    isOwaspSuppressionFile = true;
                }
                if (isOwaspSuppressionFile) {
                    return ((Xml.Document)doc).withRoot((Xml.Tag)SearchResult.found((Tree)((Xml.Document)doc).getRoot()));
                }
                return doc;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

