/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.trait.Namespaced;
import org.openrewrite.xml.tree.Xml;

public final class HasNamespaceUri
extends Recipe {
    @Option(displayName="Namespace URI", description="The Namespace URI to find.", example="http://www.w3.org/2001/XMLSchema-instance")
    private final String namespaceUri;
    @Option(displayName="XPath", description="An XPath expression used to find namespace URIs.", example="/dependencies/dependency", required=false)
    private final @Nullable String xPath;
    private final String displayName = "Find XML namespace URIs";
    private final String description = "Find XML namespace URIs, optionally restricting the search by a XPath expression.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Namespaced.matcher().xPath(this.xPath).uri(this.namespaceUri).asVisitor(n -> n.getTree() instanceof Xml.Tag ? SearchResult.found((Tree)((Xml)n.getTree())) : n.getTree());
    }

    public static Set<Xml.Tag> find(Xml x, String namespaceUri, @Nullable String xPath) {
        LinkedHashSet<Xml.Tag> ts = new LinkedHashSet<Xml.Tag>();
        Namespaced.matcher().xPath(xPath).uri(namespaceUri).asVisitor(n -> {
            if (n.getTree() instanceof Xml.Tag) {
                ts.add((Xml.Tag)n.getTree());
            }
            return n.getTree();
        }).visit((Tree)x, (Object)0);
        return ts;
    }

    @Generated
    public HasNamespaceUri(String namespaceUri, @Nullable String xPath) {
        this.namespaceUri = namespaceUri;
        this.xPath = xPath;
    }

    @Generated
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Generated
    public @Nullable String getXPath() {
        return this.xPath;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasNamespaceUri(namespaceUri=" + this.getNamespaceUri() + ", xPath=" + this.getXPath() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasNamespaceUri)) {
            return false;
        }
        HasNamespaceUri other = (HasNamespaceUri)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespaceUri = this.getNamespaceUri();
        String other$namespaceUri = other.getNamespaceUri();
        if (this$namespaceUri == null ? other$namespaceUri != null : !this$namespaceUri.equals(other$namespaceUri)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        if (this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof HasNamespaceUri;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespaceUri = this.getNamespaceUri();
        result = result * 59 + ($namespaceUri == null ? 43 : $namespaceUri.hashCode());
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

