/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class RemoveEmptyXmlTags
extends Recipe {
    final String displayName = "Remove empty XML Tag";
    final String description = "Removes XML tags that do not have attributes or children, including self closing tags.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (t != null && (((Xml.Tag)t).getContent() == null || ((Xml.Tag)t).getContent().isEmpty()) && ((Xml.Tag)t).getAttributes().isEmpty()) {
                    this.doAfterVisit(new RemoveContentVisitor((Content)t, true, true));
                }
                return t;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

