/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class ChangeTagValueVisitor<P>
extends XmlVisitor<P> {
    private final @Nullable Xml.Tag scope;
    private final @Nullable String value;

    public ChangeTagValueVisitor(@Nullable Xml.Tag scope, @Nullable String value) {
        this.scope = scope;
        this.value = value;
    }

    @Override
    public Xml visitTag(Xml.Tag tag, P p) {
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, p);
        if (this.scope != null && this.scope.isScope(t)) {
            if (this.value == null) {
                this.doAfterVisit(new RemoveContentVisitor(t, false, true));
                return tag;
            }
            String prefix = "";
            String afterText = "";
            if (t.getContent() != null && t.getContent().size() == 1 && t.getContent().get(0) instanceof Xml.CharData) {
                Xml.CharData existingValue = (Xml.CharData)t.getContent().get(0);
                if (existingValue.getText().equals(this.value)) {
                    return tag;
                }
                prefix = existingValue.getPrefix();
                afterText = existingValue.getAfterText();
            }
            t = t.withContent(Collections.singletonList(new Xml.CharData(Tree.randomId(), prefix, Markers.EMPTY, false, this.value, afterText)));
        }
        return t;
    }
}

