/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.toml.SemanticallyEqual;
import org.openrewrite.toml.TableRowMatcher;
import org.openrewrite.toml.TomlParser;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlValue;

public final class ReplaceTableRow
extends Recipe {
    @Option(displayName="Table name", description="The name of the TOML array table to replace rows in (e.g., 'package.contributors').", example="package.contributors")
    private final String tableName;
    @Option(displayName="TOML row snippet", description="The TOML key-value pairs to replace with. Should contain the objectIdentifyingProperty.", example="name = \"Alice Smith\"\\nemail = \"alice@example.com\"")
    @Language(value="toml")
    private final String row;
    @Option(displayName="Object identifying property", description="The property name used to match existing rows. When a row with this property value exists, it will be replaced; otherwise, a new row will not be inserted (see MergeTableRow).", example="name")
    private final String identifyingKey;
    private final String displayName = "Replace TOML table row";
    private final String description = "Replace a TOML table row with new content. If a row with the same identifying property exists, replace it entirely.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TomlVisitor<ExecutionContext>(){

            @Override
            public Toml visitTable(Toml.Table table, ExecutionContext ctx) {
                if (table.getName() == null || !ReplaceTableRow.this.tableName.equals(table.getName().getName())) {
                    return super.visitTable(table, ctx);
                }
                List<Toml.KeyValue> incomingKeyValues = this.parseTomlRow(ReplaceTableRow.this.row);
                if (incomingKeyValues.isEmpty()) {
                    return super.visitTable(table, ctx);
                }
                String identifyingValue = TableRowMatcher.getKeyValue(incomingKeyValues, ReplaceTableRow.this.identifyingKey);
                if (identifyingValue == null) {
                    return super.visitTable(table, ctx);
                }
                String tableIdentifyingValue = TableRowMatcher.getKeyValue(table, ReplaceTableRow.this.identifyingKey);
                if (identifyingValue.equals(tableIdentifyingValue)) {
                    Space firstPrefix = table.getValues().isEmpty() ? Space.format("\n") : table.getValues().get(0).getPrefix();
                    return table.withValues(ListUtils.mapFirst((List)ListUtils.concatAll((List)ListUtils.map(table.getValues(), value -> {
                        if (!(value instanceof Toml.KeyValue)) {
                            return null;
                        }
                        Toml.KeyValue existingKv = (Toml.KeyValue)value;
                        for (int i = 0; i < incomingKeyValues.size(); ++i) {
                            Toml.KeyValue incomingKv = (Toml.KeyValue)incomingKeyValues.get(i);
                            if (!SemanticallyEqual.areEqual(existingKv.getKey(), incomingKv.getKey())) continue;
                            incomingKeyValues.remove(i);
                            if (!SemanticallyEqual.areEqual(existingKv.getValue(), incomingKv.getValue())) {
                                return incomingKv.withPrefix(existingKv.getPrefix());
                            }
                            return existingKv;
                        }
                        return null;
                    }), incomingKeyValues), first -> first.withPrefix(firstPrefix)));
                }
                return super.visitTable(table, ctx);
            }

            private List<Toml.KeyValue> parseTomlRow(@Language(value="toml") String tomlContent) {
                try {
                    Toml.Document doc = new TomlParser().parse(tomlContent).findFirst().map(Toml.Document.class::cast).orElse(null);
                    if (doc != null && !doc.getValues().isEmpty()) {
                        ArrayList<Toml.KeyValue> result = new ArrayList<Toml.KeyValue>();
                        for (TomlValue value : doc.getValues()) {
                            if (!(value instanceof Toml.KeyValue)) continue;
                            result.add((Toml.KeyValue)value);
                        }
                        return result;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Collections.emptyList();
            }
        };
    }

    @Generated
    public ReplaceTableRow(String tableName, @Language(value="toml") String row, String identifyingKey) {
        this.tableName = tableName;
        this.row = row;
        this.identifyingKey = identifyingKey;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Language(value="toml")
    @Generated
    public String getRow() {
        return this.row;
    }

    @Generated
    public String getIdentifyingKey() {
        return this.identifyingKey;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceTableRow(tableName=" + this.getTableName() + ", row=" + this.getRow() + ", identifyingKey=" + this.getIdentifyingKey() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceTableRow)) {
            return false;
        }
        ReplaceTableRow other = (ReplaceTableRow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$row = this.getRow();
        String other$row = other.getRow();
        if (this$row == null ? other$row != null : !this$row.equals(other$row)) {
            return false;
        }
        String this$identifyingKey = this.getIdentifyingKey();
        String other$identifyingKey = other.getIdentifyingKey();
        if (this$identifyingKey == null ? other$identifyingKey != null : !this$identifyingKey.equals(other$identifyingKey)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceTableRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : $row.hashCode());
        String $identifyingKey = this.getIdentifyingKey();
        result = result * 59 + ($identifyingKey == null ? 43 : $identifyingKey.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

