/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class DeleteProperty
extends Recipe {
    private final String displayName = "Delete property by key";
    private final String description = "Deletes key/value pairs from properties files, as well as any comments that immediately precede the key/value pair. Comments separated by two or more newlines from the deleted key/value pair are preserved.";
    @Option(displayName="Property key matcher", description="The key(s) to be deleted. This is a glob expression.", example="management.metrics.binders.files.enabled or management.metrics.*")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    private final @Nullable Boolean relaxedBinding;

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitFile(Properties.File file, ExecutionContext ctx) {
                Properties.File f1 = (Properties.File)super.visitFile(file, ctx);
                AtomicReference<@Nullable Object> prefixOnNextEntry = new AtomicReference<Object>(null);
                AtomicBoolean deleted = new AtomicBoolean(false);
                Properties.File mapped = f1.withContent(ListUtils.map(f1.getContent(), (index, current) -> {
                    String prefix;
                    if (current instanceof Properties.Comment && this.nextEntryMatches(f1.getContent(), (int)index)) {
                        prefixOnNextEntry.compareAndSet(null, current.getPrefix());
                        return null;
                    }
                    if (this.isMatch((Properties.Content)current)) {
                        deleted.set(true);
                        return null;
                    }
                    if (deleted.getAndSet(false) && (prefix = (String)prefixOnNextEntry.getAndSet(null)) != null) {
                        return (Properties.Content)current.withPrefix(prefix);
                    }
                    return current;
                }));
                if (f1 != mapped) {
                    return mapped.withContent(ListUtils.mapFirst(mapped.getContent(), c -> (Properties.Content)c.withPrefix("")));
                }
                return mapped;
            }

            private boolean isMatch(Properties.Content current) {
                if (current instanceof Properties.Entry) {
                    String key = ((Properties.Entry)current).getKey();
                    if (Boolean.FALSE.equals(DeleteProperty.this.relaxedBinding)) {
                        return StringUtils.matchesGlob((String)key, (String)DeleteProperty.this.propertyKey);
                    }
                    return StringUtils.matchesGlob((String)NameCaseConvention.LOWER_CAMEL.format(key), (String)NameCaseConvention.LOWER_CAMEL.format(DeleteProperty.this.propertyKey));
                }
                return false;
            }

            private boolean nextEntryMatches(List<Properties.Content> contents, int index) {
                while (++index < contents.size()) {
                    Properties.Content next = contents.get(index);
                    if (next.getPrefix().matches("\\R{2,}")) {
                        return false;
                    }
                    if (this.isMatch(next)) {
                        return true;
                    }
                    if (!(next instanceof Properties.Entry)) continue;
                    return false;
                }
                return false;
            }
        };
    }

    @Generated
    public DeleteProperty(String propertyKey, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public @Nullable Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteProperty(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", propertyKey=" + this.getPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProperty)) {
            return false;
        }
        DeleteProperty other = (DeleteProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }
}

