/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.Nullable;

public class Version
implements Comparable<Version> {
    private final String version;
    private final Item[] items;

    public Version(String version) {
        this.version = version;
        this.items = Version.parse(version);
    }

    private static Item[] parse(String version) {
        ArrayList<Item> items = new ArrayList<Item>();
        Tokenizer tokenizer = new Tokenizer(version);
        while (tokenizer.next()) {
            Item item = tokenizer.toItem();
            items.add(item);
        }
        Version.trimPadding(items);
        return items.toArray(new Item[0]);
    }

    private static void trimPadding(List<Item> items) {
        int end;
        Boolean number = null;
        for (int i = end = items.size() - 1; i > 0; --i) {
            Item item = items.get(i);
            if (!Boolean.valueOf(item.isNumber()).equals(number)) {
                end = i;
                number = item.isNumber();
            }
            if (end != i || i != items.size() - 1 && items.get(i - 1).isNumber() != item.isNumber() || item.compareTo(null) != 0) continue;
            items.remove(i);
            --end;
        }
    }

    @Override
    public int compareTo(Version obj) {
        Item[] these = this.items;
        Item[] those = obj.items;
        boolean number = true;
        for (int index = 0; index < these.length || index < those.length; ++index) {
            if (index >= these.length) {
                return -Version.comparePadding(those, index, null);
            }
            if (index >= those.length) {
                return Version.comparePadding(these, index, null);
            }
            Item thisItem = these[index];
            Item thatItem = those[index];
            if (thisItem.isNumber() != thatItem.isNumber()) {
                if (number == thisItem.isNumber()) {
                    return Version.comparePadding(these, index, number);
                }
                return -Version.comparePadding(those, index, number);
            }
            int rel = thisItem.compareTo(thatItem);
            if (rel != 0) {
                return rel;
            }
            number = thisItem.isNumber();
        }
        return 0;
    }

    private static int comparePadding(Item[] items, int index, @Nullable Boolean number) {
        int rel = 0;
        for (int i = index; i < items.length; ++i) {
            Item item = items[i];
            if (number != null && number.booleanValue() != item.isNumber() || (rel = item.compareTo(null)) != 0) break;
        }
        return rel;
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }

    static final class Item {
        private static final Item MAX = new Item(8, "max");
        private static final Item MIN = new Item(0, "min");
        private final int kind;
        private final Object value;

        Item(int kind, Object value) {
            this.kind = kind;
            this.value = value;
        }

        public boolean isNumber() {
            return (this.kind & 2) == 0;
        }

        public int compareTo(@Nullable Item that) {
            int rel;
            if (that == null) {
                switch (this.kind) {
                    case 0: {
                        rel = -1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown version item kind " + this.kind);
                    }
                    case 2: 
                    case 4: {
                        rel = (Integer)this.value;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 8: {
                        rel = 1;
                        break;
                    }
                }
            } else {
                rel = this.kind - that.kind;
                if (rel == 0) {
                    switch (this.kind) {
                        case 0: 
                        case 8: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                        case 2: 
                        case 4: {
                            rel = ((Integer)this.value).compareTo((Integer)that.value);
                            break;
                        }
                        case 3: {
                            rel = ((String)this.value).compareToIgnoreCase((String)that.value);
                            break;
                        }
                        case 5: {
                            rel = ((BigInteger)this.value).compareTo((BigInteger)that.value);
                        }
                    }
                }
            }
            return rel;
        }

        public boolean equals(Object obj) {
            return obj instanceof Item && this.compareTo((Item)obj) == 0;
        }

        public int hashCode() {
            return this.value.hashCode() + this.kind * 31;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class Tokenizer {
        private static final Integer QUALIFIER_ALPHA = -5;
        private static final Integer QUALIFIER_BETA = -4;
        private static final Integer QUALIFIER_MILESTONE = -3;
        private final String version;
        private int index;
        private int tokenStart;
        private int tokenEnd;
        private boolean number;
        private boolean terminatedByNumber;

        Tokenizer(String version) {
            this.version = !version.isEmpty() ? version : "0";
        }

        public boolean next() {
            int n = this.version.length();
            if (this.index >= n) {
                return false;
            }
            int state = -2;
            int start = this.index;
            int end = n;
            this.terminatedByNumber = false;
            while (this.index < n) {
                char c = this.version.charAt(this.index);
                if (c == '.' || c == '-' || c == '_') {
                    end = this.index++;
                    break;
                }
                int digit = Character.digit(c, 10);
                if (digit >= 0) {
                    if (state == -1) {
                        end = this.index;
                        this.terminatedByNumber = true;
                        break;
                    }
                    if (state == 0) {
                        ++start;
                    }
                    state = state <= 0 && digit <= 0 ? 0 : 1;
                } else {
                    if (state >= 0) {
                        end = this.index;
                        break;
                    }
                    state = -1;
                }
                ++this.index;
            }
            if (end > start) {
                this.tokenStart = start;
                this.tokenEnd = end;
                this.number = state >= 0;
            } else {
                this.tokenStart = 0;
                this.tokenEnd = 1;
                this.number = true;
            }
            return true;
        }

        public String toString() {
            return this.version.substring(this.tokenStart, this.tokenEnd);
        }

        public Item toItem() {
            if (this.number) {
                try {
                    int tokenLength = this.tokenEnd - this.tokenStart;
                    return tokenLength < 10 ? new Item(4, Tokenizer.parseInt(this.version, this.tokenStart, this.tokenEnd)) : new Item(5, new BigInteger(this.version.substring(this.tokenStart, this.tokenEnd)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal version: " + this.version.substring(this.tokenStart, this.tokenEnd), e);
                }
            }
            int tokenLength = this.tokenEnd - this.tokenStart;
            if (this.index >= this.version.length()) {
                if (tokenLength == 3 && this.matches("min")) {
                    return Item.MIN;
                }
                if (tokenLength == 3 && this.matches("max")) {
                    return Item.MAX;
                }
            }
            if (this.terminatedByNumber && tokenLength == 1) {
                char c = this.version.charAt(this.tokenStart);
                switch (c) {
                    case 'A': 
                    case 'a': {
                        return new Item(2, QUALIFIER_ALPHA);
                    }
                    case 'B': 
                    case 'b': {
                        return new Item(2, QUALIFIER_BETA);
                    }
                    case 'M': 
                    case 'm': {
                        return new Item(2, QUALIFIER_MILESTONE);
                    }
                }
            }
            switch (tokenLength) {
                case 0: {
                    return new Item(2, 0);
                }
                case 2: {
                    if (this.matches("ga")) {
                        return new Item(2, 0);
                    }
                    if (this.matches("rc")) {
                        return new Item(2, -2);
                    }
                    if (this.matches("cr")) {
                        return new Item(2, -2);
                    }
                    if (!this.matches("sp")) break;
                    return new Item(2, 1);
                }
                case 4: {
                    if (!this.matches("beta")) break;
                    return new Item(2, QUALIFIER_BETA);
                }
                case 5: {
                    if (this.matches("alpha")) {
                        return new Item(2, QUALIFIER_ALPHA);
                    }
                    if (!this.matches("final")) break;
                    return new Item(2, 0);
                }
                case 7: {
                    if (!this.matches("release")) break;
                    return new Item(2, 0);
                }
                case 8: {
                    if (!this.matches("snapshot")) break;
                    return new Item(2, -1);
                }
                case 9: {
                    if (!this.matches("milestone")) break;
                    return new Item(2, QUALIFIER_MILESTONE);
                }
            }
            String token = this.version.substring(this.tokenStart, this.tokenEnd);
            return new Item(3, token.toLowerCase(Locale.ENGLISH));
        }

        private static int parseInt(String s, int beginIndex, int endIndex) throws NumberFormatException {
            if (beginIndex >= endIndex) {
                throw new NumberFormatException("Empty string");
            }
            int result = 0;
            int i = beginIndex;
            int limit = -2147483647;
            int multmin = limit / 10;
            char firstChar = s.charAt(i);
            if (firstChar < '0' || firstChar > '9') {
                throw new NumberFormatException("Invalid character");
            }
            while (i < endIndex) {
                int digit;
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("Invalid character");
                }
                if (result < multmin) {
                    throw new NumberFormatException("Value out of range");
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException("Value out of range");
                }
                result -= digit;
            }
            return -result;
        }

        private boolean matches(String target) {
            return this.version.regionMatches(true, this.tokenStart, target, 0, target.length());
        }
    }
}

