/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.ManagedDependencyGraph;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.tree.Xml;

public final class EffectiveManagedDependencies
extends Recipe {
    private final transient ManagedDependencyGraph dependencyGraph = new ManagedDependencyGraph(this);
    private final String displayName = "Effective managed dependencies";
    private final String description = "Emit the data of binary dependency relationships.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                EffectiveManagedDependencies.this.emitParent(mrr, ctx);
                return document;
            }
        };
    }

    private void emitParent(MavenResolutionResult mrr, ExecutionContext ctx) {
        if (mrr.getParent() != null) {
            this.dependencyGraph.insertRow(ctx, new ManagedDependencyGraph.Row(String.format("%s:%s:%s", mrr.getPom().getGroupId(), mrr.getPom().getArtifactId(), mrr.getPom().getVersion()), String.format("%s:%s:%s", mrr.getParent().getPom().getGroupId(), mrr.getParent().getPom().getArtifactId(), mrr.getParent().getPom().getVersion())));
            for (ResolvedManagedDependency managed : mrr.getPom().getDependencyManagement()) {
                this.dependencyGraph.insertRow(ctx, new ManagedDependencyGraph.Row(String.format("%s:%s:%s", mrr.getPom().getGroupId(), mrr.getPom().getArtifactId(), mrr.getPom().getVersion()), String.format("%s:%s:%s", managed.getGroupId(), managed.getArtifactId(), managed.getVersion())));
            }
        }
    }

    @Generated
    public EffectiveManagedDependencies() {
    }

    @Generated
    public ManagedDependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EffectiveManagedDependencies(dependencyGraph=" + (Object)((Object)this.getDependencyGraph()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveManagedDependencies)) {
            return false;
        }
        EffectiveManagedDependencies other = (EffectiveManagedDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EffectiveManagedDependencies;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

