/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.ObjectMappers;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;

@XmlRootElement(name="project")
public class RawGradleModule {
    private static final ObjectMapper mapper = ObjectMappers.propertyBasedMapper((ClassLoader)RawGradleModule.class.getClassLoader());
    private final @Nullable String formatVersion;
    private final @Nullable Component component;
    private final @Nullable List<Variant> variants;

    public static RawGradleModule parse(InputStream inputStream) {
        try {
            return (RawGradleModule)mapper.readValue(inputStream, RawGradleModule.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse module", e);
        }
    }

    public List<org.openrewrite.maven.tree.Dependency> getDependencies(String variant, String ... categories) {
        return this.variants == null ? Collections.emptyList() : this.variants.stream().filter(v -> v.getName().equals(variant)).map(Variant::getDependencies).filter(Objects::nonNull).flatMap(Collection::stream).filter(d -> categories.length == 0 || d.getAttributes() != null && d.getAttributes().getCategory() != null && Arrays.stream(categories).anyMatch(cat -> d.getAttributes().getCategory().equalsIgnoreCase((String)cat))).map(dep -> {
            Dependency.DependencyBuilder builder = org.openrewrite.maven.tree.Dependency.builder().gav(dep.asGav());
            if (dep.getAttributes() != null && dep.getAttributes().getCategory() != null) {
                builder.attributes(Collections.singletonMap("org.gradle.category", dep.getAttributes().getCategory()));
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    @NonNull
    @Generated
    public String toString() {
        return "RawGradleModule()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawGradleModule)) {
            return false;
        }
        RawGradleModule other = (RawGradleModule)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RawGradleModule;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public RawGradleModule(@Nullable String formatVersion, @Nullable Component component, @Nullable List<Variant> variants) {
        this.formatVersion = formatVersion;
        this.component = component;
        this.variants = variants;
    }

    @Generated
    public @Nullable String getFormatVersion() {
        return this.formatVersion;
    }

    @Generated
    public @Nullable Component getComponent() {
        return this.component;
    }

    @Generated
    public @Nullable List<Variant> getVariants() {
        return this.variants;
    }

    public static class Component {
        private final String groupId;
        private final String module;
        private final @Nullable String version;

        @Generated
        public Component(String groupId, String module, @Nullable String version) {
            this.groupId = groupId;
            this.module = module;
            this.version = version;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getModule() {
            return this.module;
        }

        @Generated
        public @Nullable String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Component)) {
                return false;
            }
            Component other = (Component)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Component;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawGradleModule.Component(groupId=" + this.getGroupId() + ", module=" + this.getModule() + ", version=" + this.getVersion() + ")";
        }
    }

    public static class Dependency {
        private final String group;
        private final String module;
        private final @Nullable Version version;
        private final @Nullable DependencyAttributes attributes;

        GroupArtifactVersion asGav() {
            return new GroupArtifactVersion(this.group, this.module, this.version == null ? null : this.version.getRequires());
        }

        @Generated
        public Dependency(String group, String module, @Nullable Version version, @Nullable DependencyAttributes attributes) {
            this.group = group;
            this.module = module;
            this.version = version;
            this.attributes = attributes;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getModule() {
            return this.module;
        }

        @Generated
        public @Nullable Version getVersion() {
            return this.version;
        }

        @Generated
        public @Nullable DependencyAttributes getAttributes() {
            return this.attributes;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            DependencyAttributes this$attributes = this.getAttributes();
            DependencyAttributes other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Dependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            DependencyAttributes $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawGradleModule.Dependency(group=" + this.getGroup() + ", module=" + this.getModule() + ", version=" + this.getVersion() + ", attributes=" + this.getAttributes() + ")";
        }
    }

    public static class DependencyAttributes {
        @JsonProperty(value="org.gradle.category")
        private final @Nullable String category;

        @Generated
        public DependencyAttributes(@Nullable String category) {
            this.category = category;
        }

        @Generated
        public @Nullable String getCategory() {
            return this.category;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyAttributes)) {
                return false;
            }
            DependencyAttributes other = (DependencyAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            return !(this$category == null ? other$category != null : !this$category.equals(other$category));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof DependencyAttributes;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawGradleModule.DependencyAttributes(category=" + this.getCategory() + ")";
        }
    }

    public static class Variant {
        private final String name;
        private final @Nullable List<Dependency> dependencies;

        @Generated
        public Variant(String name, @Nullable List<Dependency> dependencies) {
            this.name = name;
            this.dependencies = dependencies;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @Nullable List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Variant)) {
                return false;
            }
            Variant other = (Variant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Variant;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawGradleModule.Variant(name=" + this.getName() + ", dependencies=" + this.getDependencies() + ")";
        }
    }

    public static class Version {
        private final String requires;

        @Generated
        public Version(String requires) {
            this.requires = requires;
        }

        @Generated
        public String getRequires() {
            return this.requires;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requires = this.getRequires();
            String other$requires = other.getRequires();
            return !(this$requires == null ? other$requires != null : !this$requires.equals(other$requires));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Version;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requires = this.getRequires();
            result = result * 59 + ($requires == null ? 43 : $requires.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawGradleModule.Version(requires=" + this.getRequires() + ")";
        }
    }
}

