/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class UseParentInference
extends Recipe {
    final String displayName = "Use Maven 4 parent inference";
    final String description = "Maven 4.1.0 supports automatic parent version inference when using a relative path. This recipe simplifies parent declarations by using the shorthand `<parent/>` form when the parent is in the default location (`..`), removing the explicit `<relativePath>`, `<groupId>`, `<artifactId>`, and `<version>` elements. Maven automatically infers these values from the parent POM.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional relativePathTag;
                String relativePath;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isParentTag() && tag.getContent() != null && !tag.getContent().isEmpty() && ("..".equals(relativePath = (String)(relativePathTag = t.getChild("relativePath")).map(rp -> rp.getValue().orElse("")).orElse(null)) || "../".equals(relativePath))) {
                    return Xml.Tag.build((String)"<parent/>").withPrefix(tag.getPrefix());
                }
                return t;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

