/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveProperty
extends Recipe {
    @Option(displayName="Property name", description="Key name of the property to remove.", example="junit.version")
    private final String propertyName;
    private final String displayName = "Remove Maven project property";
    private final String description = "Removes the specified Maven project property from the pom.xml.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemovePropertyVisitor();
    }

    @Generated
    public RemoveProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    @Generated
    public String getPropertyName() {
        return this.propertyName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveProperty(propertyName=" + this.getPropertyName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveProperty)) {
            return false;
        }
        RemoveProperty other = (RemoveProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private class RemovePropertyVisitor
    extends MavenVisitor<ExecutionContext> {
        private RemovePropertyVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isPropertyTag() && RemoveProperty.this.propertyName.equals(tag.getName())) {
                this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true, true));
                this.maybeUpdateModel();
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

